/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.route.RestClientRibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.ZuulFallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.apache.HttpClientRibbonCommandFactory;
import org.springframework.cloud.netflix.zuul.filters.route.okhttp.OkHttpRibbonCommandFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

public class RibbonCommandFactoryConfiguration {

    private static class OnRibbonRestClientCondition
    extends AnyNestedCondition {
        public OnRibbonRestClientCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"ribbon.restclient.enabled"})
        static class RibbonProperty {
            RibbonProperty() {
            }
        }

        @Deprecated
        @ConditionalOnProperty(value={"zuul.ribbon.restclient.enabled"})
        static class ZuulProperty {
            ZuulProperty() {
            }
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OnRibbonRestClientCondition.class})
    static @interface ConditionalOnRibbonRestClient {
    }

    private static class OnRibbonOkHttpClientCondition
    extends AnyNestedCondition {
        public OnRibbonOkHttpClientCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"ribbon.okhttp.enabled"})
        static class RibbonProperty {
            RibbonProperty() {
            }
        }

        @Deprecated
        @ConditionalOnProperty(value={"zuul.ribbon.okhttp.enabled"})
        static class ZuulProperty {
            ZuulProperty() {
            }
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OnRibbonOkHttpClientCondition.class})
    static @interface ConditionalOnRibbonOkHttpClient {
    }

    private static class OnRibbonHttpClientCondition
    extends AnyNestedCondition {
        public OnRibbonHttpClientCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"ribbon.httpclient.enabled"}, matchIfMissing=true)
        static class RibbonProperty {
            RibbonProperty() {
            }
        }

        @Deprecated
        @ConditionalOnProperty(name={"zuul.ribbon.httpclient.enabled"}, matchIfMissing=true)
        static class ZuulProperty {
            ZuulProperty() {
            }
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OnRibbonHttpClientCondition.class})
    static @interface ConditionalOnRibbonHttpClient {
    }

    @Configuration
    @ConditionalOnRibbonHttpClient
    protected static class HttpClientRibbonConfiguration {
        @Autowired(required=false)
        private Set<ZuulFallbackProvider> zuulFallbackProviders = Collections.emptySet();

        protected HttpClientRibbonConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RibbonCommandFactory<?> ribbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
            return new HttpClientRibbonCommandFactory(clientFactory, zuulProperties, this.zuulFallbackProviders);
        }
    }

    @Configuration
    @ConditionalOnRibbonOkHttpClient
    @ConditionalOnClass(name={"okhttp3.OkHttpClient"})
    protected static class OkHttpRibbonConfiguration {
        @Autowired(required=false)
        private Set<ZuulFallbackProvider> zuulFallbackProviders = Collections.emptySet();

        protected OkHttpRibbonConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RibbonCommandFactory<?> ribbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
            return new OkHttpRibbonCommandFactory(clientFactory, zuulProperties, this.zuulFallbackProviders);
        }
    }

    @Configuration
    @ConditionalOnRibbonRestClient
    protected static class RestClientRibbonConfiguration {
        @Autowired(required=false)
        private Set<ZuulFallbackProvider> zuulFallbackProviders = Collections.emptySet();

        protected RestClientRibbonConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RibbonCommandFactory<?> ribbonCommandFactory(SpringClientFactory clientFactory, ZuulProperties zuulProperties) {
            return new RestClientRibbonCommandFactory(clientFactory, zuulProperties, this.zuulFallbackProviders);
        }
    }
}

