/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.support;

import com.netflix.client.ClientRequest;
import java.net.URI;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;

public abstract class ContextAwareRequest
extends ClientRequest {
    protected final RibbonCommandContext context;

    public ContextAwareRequest(RibbonCommandContext context) {
        this.context = context;
        this.uri = context.uri();
        this.isRetriable = context.getRetryable();
    }

    public RibbonCommandContext getContext() {
        return this.context;
    }

    protected RibbonCommandContext newContext(URI uri) {
        RibbonCommandContext commandContext = new RibbonCommandContext(this.context.getServiceId(), this.context.getMethod(), uri.toString(), this.context.getRetryable(), this.context.getHeaders(), this.context.getParams(), this.context.getRequestEntity(), this.context.getRequestCustomizers(), this.context.getContentLength());
        return commandContext;
    }
}

