/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.springframework.cloud.netflix.feign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestParamParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestParam> ANNOTATION = RequestParam.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation) {
        RequestParam requestParam = ANNOTATION.cast(annotation);
        String name = requestParam.value();
        if (Util.emptyToNull((String)name) != null) {
            context.setParameterName(name);
            MethodMetadata data = context.getMethodMetadata();
            Collection<String> query = context.setTemplateParameter(name, (Collection)data.template().queries().get(name));
            data.template().query(name, query);
        } else {
            MethodMetadata data = context.getMethodMetadata();
            data.queryMapIndex(Integer.valueOf(context.getParameterIndex()));
        }
        return true;
    }
}

