/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.springframework.cloud.netflix.feign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestHeader;

public class RequestHeaderParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestHeader> ANNOTATION = RequestHeader.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation) {
        String name = ANNOTATION.cast(annotation).value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"RequestHeader.value() was empty on parameter %s", (Object[])new Object[]{context.getParameterIndex()});
        context.setParameterName(name);
        MethodMetadata data = context.getMethodMetadata();
        Collection<String> header = context.setTemplateParameter(name, (Collection)data.template().headers().get(name));
        data.template().header(name, header);
        return true;
    }
}

