/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Feign;
import feign.Target;
import feign.hystrix.FallbackFactory;
import feign.hystrix.HystrixFeign;
import org.springframework.cloud.netflix.feign.FeignClientFactoryBean;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.netflix.feign.Targeter;
import org.springframework.util.Assert;

class HystrixTargeter
implements Targeter {
    HystrixTargeter() {
    }

    @Override
    public <T> T target(FeignClientFactoryBean factory, Feign.Builder feign, FeignContext context, Target.HardCodedTarget<T> target) {
        if (!(feign instanceof HystrixFeign.Builder)) {
            return (T)feign.target(target);
        }
        HystrixFeign.Builder builder = (HystrixFeign.Builder)feign;
        Class<?> fallback = factory.getFallback();
        if (fallback != Void.TYPE) {
            return this.targetWithFallback(factory.getName(), context, target, builder, fallback);
        }
        Class<?> fallbackFactory = factory.getFallbackFactory();
        if (fallbackFactory != Void.TYPE) {
            return this.targetWithFallbackFactory(factory.getName(), context, target, builder, fallbackFactory);
        }
        return (T)feign.target(target);
    }

    private <T> T targetWithFallbackFactory(String feignClientName, FeignContext context, Target.HardCodedTarget<T> target, HystrixFeign.Builder builder, Class<?> fallbackFactoryClass) {
        FallbackFactory fallbackFactory = this.getFromContext("fallbackFactory", feignClientName, context, fallbackFactoryClass, FallbackFactory.class);
        Object exampleFallback = fallbackFactory.create((Throwable)new RuntimeException());
        Assert.notNull((Object)exampleFallback, (String)String.format("Incompatible fallbackFactory instance for feign client %s. Factory may not produce null!", feignClientName));
        if (!target.type().isAssignableFrom(exampleFallback.getClass())) {
            throw new IllegalStateException(String.format("Incompatible fallbackFactory instance for feign client %s. Factory produces instances of '%s', but should produce instances of '%s'", feignClientName, exampleFallback.getClass(), target.type()));
        }
        return (T)builder.target(target, fallbackFactory);
    }

    private <T> T targetWithFallback(String feignClientName, FeignContext context, Target.HardCodedTarget<T> target, HystrixFeign.Builder builder, Class<?> fallback) {
        T fallbackInstance = this.getFromContext("fallback", feignClientName, context, fallback, target.type());
        return (T)builder.target(target, fallbackInstance);
    }

    private <T> T getFromContext(String fallbackMechanism, String feignClientName, FeignContext context, Class<?> beanType, Class<T> targetType) {
        Object fallbackInstance = context.getInstance(feignClientName, beanType);
        if (fallbackInstance == null) {
            throw new IllegalStateException(String.format("No " + fallbackMechanism + " instance of type %s found for feign client %s", beanType, feignClientName));
        }
        if (!targetType.isAssignableFrom(beanType)) {
            throw new IllegalStateException(String.format("Incompatible " + fallbackMechanism + " instance. Fallback/fallbackFactory of type %s is not assignable to %s for feign client %s", beanType, targetType, feignClientName));
        }
        return (T)fallbackInstance;
    }
}

