/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.zuul.filters.ProxyRouteLocator;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;

public class PreDecorationFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(PreDecorationFilter.class);
    private ProxyRouteLocator routeLocator;
    private boolean addProxyHeaders;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public PreDecorationFilter(ProxyRouteLocator routeLocator, boolean addProxyHeaders) {
        this.routeLocator = routeLocator;
        this.addProxyHeaders = addProxyHeaders;
    }

    public int filterOrder() {
        return 5;
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        String requestURI = this.urlPathHelper.getPathWithinApplication(ctx.getRequest());
        ProxyRouteLocator.ProxyRouteSpec route = this.routeLocator.getMatchingRoute(requestURI);
        if (route != null) {
            String location = route.getLocation();
            if (location != null) {
                ctx.put((Object)"requestURI", (Object)route.getPath());
                ctx.put((Object)"proxy", (Object)route.getId());
                if (route.getRetryable() != null) {
                    ctx.put((Object)"retryable", (Object)route.getRetryable());
                }
                if (location.startsWith("http:") || location.startsWith("https:")) {
                    ctx.setRouteHost(this.getUrl(location));
                    ctx.addOriginResponseHeader("X-Zuul-Service", location);
                } else {
                    ctx.set("serviceId", (Object)location);
                    ctx.setRouteHost(null);
                    ctx.addOriginResponseHeader("X-Zuul-ServiceId", location);
                }
                if (this.addProxyHeaders) {
                    ctx.addZuulRequestHeader("X-Forwarded-Host", ctx.getRequest().getServerName() + ":" + String.valueOf(ctx.getRequest().getServerPort()));
                    if (StringUtils.hasText((String)route.getPrefix())) {
                        ctx.addZuulRequestHeader("X-Forwarded-Prefix", route.getPrefix());
                    }
                }
            }
        } else {
            log.warn((Object)("No route found for uri: " + requestURI));
            ctx.set("error.status_code", (Object)404);
        }
        return null;
    }

    private URL getUrl(String target) {
        try {
            return new URL(target);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Target URL is malformed", ex);
        }
    }
}

