/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import com.netflix.zuul.http.ServletInputStreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.pre.Servlet30RequestWrapper;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.servlet.DispatcherServlet;

public class FormBodyWrapperFilter
extends ZuulFilter {
    private Field requestField = ReflectionUtils.findField(HttpServletRequestWrapper.class, (String)"req", HttpServletRequest.class);

    public FormBodyWrapperFilter() {
        Assert.notNull((Object)this.requestField, (String)"HttpServletRequestWrapper.req field not found");
        this.requestField.setAccessible(true);
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -1;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.valueOf((String)contentType);
            return MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType) || this.isDispatcherServletRequest(request) && MediaType.MULTIPART_FORM_DATA.includes(mediaType);
        }
        catch (InvalidMediaTypeException ex) {
            return false;
        }
    }

    private boolean isDispatcherServletRequest(HttpServletRequest request) {
        return request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        FormBodyRequestWrapper wrapper = null;
        if (request instanceof HttpServletRequestWrapper) {
            HttpServletRequest wrapped = (HttpServletRequest)ReflectionUtils.getField((Field)this.requestField, (Object)request);
            wrapper = new FormBodyRequestWrapper(wrapped);
            ReflectionUtils.setField((Field)this.requestField, (Object)request, (Object)((Object)wrapper));
        } else {
            wrapper = new FormBodyRequestWrapper(request);
            ctx.setRequest((HttpServletRequest)wrapper);
        }
        if (wrapper != null) {
            ctx.getZuulRequestHeaders().put("content-type", wrapper.getContentType());
        }
        return null;
    }

    private class FormBodyRequestWrapper
    extends Servlet30RequestWrapper {
        private HttpServletRequest request;
        private byte[] contentData;
        private MediaType contentType;
        private int contentLength;
        private AllEncompassingFormHttpMessageConverter converter;

        public FormBodyRequestWrapper(HttpServletRequest request) {
            super(request);
            this.converter = new AllEncompassingFormHttpMessageConverter();
            this.request = request;
        }

        public String getContentType() {
            if (this.contentData == null) {
                this.buildContentData();
            }
            return this.contentType.toString();
        }

        public int getContentLength() {
            if (super.getContentLength() <= 0) {
                return super.getContentLength();
            }
            if (this.contentData == null) {
                this.buildContentData();
            }
            return this.contentLength;
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.contentData == null) {
                this.buildContentData();
            }
            return new ServletInputStreamWrapper(this.contentData);
        }

        private synchronized void buildContentData() {
            try {
                LinkedMultiValueMap builder = new LinkedMultiValueMap();
                for (Map.Entry entry : this.request.getParameterMap().entrySet()) {
                    for (String value : (String[])entry.getValue()) {
                        builder.add(entry.getKey(), (Object)value);
                    }
                }
                if (this.request instanceof MultipartRequest) {
                    MultipartRequest multi = (MultipartRequest)this.request;
                    for (Map.Entry part : multi.getFileMap().entrySet()) {
                        MultipartFile file = (MultipartFile)part.getValue();
                        HttpHeaders headers = new HttpHeaders();
                        headers.setContentDispositionFormData(file.getName(), file.getOriginalFilename());
                        headers.setContentType(MediaType.valueOf((String)file.getContentType()));
                        HttpEntity entity = new HttpEntity((Object)file.getBytes(), (MultiValueMap)headers);
                        builder.set(part.getKey(), (Object)entity);
                    }
                }
                FormHttpOutputMessage data = new FormHttpOutputMessage();
                this.contentType = MediaType.valueOf((String)this.request.getContentType());
                data.getHeaders().setContentType(this.contentType);
                this.converter.write((MultiValueMap)builder, this.contentType, (HttpOutputMessage)data);
                this.contentType = data.getHeaders().getContentType();
                this.contentData = data.getInput();
                this.contentLength = this.contentData.length;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert form data", e);
            }
        }

        private class FormHttpOutputMessage
        implements HttpOutputMessage {
            private HttpHeaders headers = new HttpHeaders();
            private ByteArrayOutputStream output = new ByteArrayOutputStream();

            private FormHttpOutputMessage() {
            }

            public HttpHeaders getHeaders() {
                return this.headers;
            }

            public OutputStream getBody() throws IOException {
                return this.output;
            }

            public byte[] getInput() throws IOException {
                this.output.flush();
                return this.output.toByteArray();
            }
        }
    }
}

