/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.util.Pair;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.ReflectionUtils;

public class SendResponseFilter
extends ZuulFilter {
    private static DynamicBooleanProperty INCLUDE_DEBUG_HEADER = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.include-debug-header", false);
    private static DynamicIntProperty INITIAL_STREAM_BUFFER_SIZE = DynamicPropertyFactory.getInstance().getIntProperty("zuul.initial-stream-buffer-size", 1024);
    private static DynamicBooleanProperty SET_CONTENT_LENGTH = DynamicPropertyFactory.getInstance().getBooleanProperty("zuul.set-content-length", false);

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 1000;
    }

    public boolean shouldFilter() {
        return !RequestContext.getCurrentContext().getZuulResponseHeaders().isEmpty() || RequestContext.getCurrentContext().getResponseDataStream() != null || RequestContext.getCurrentContext().getResponseBody() != null;
    }

    public Object run() {
        try {
            this.addResponseHeaders();
            this.writeResponse();
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse() throws Exception {
        RequestContext context = RequestContext.getCurrentContext();
        if (context.getResponseBody() == null && context.getResponseDataStream() == null) {
            return;
        }
        HttpServletResponse servletResponse = context.getResponse();
        servletResponse.setCharacterEncoding("UTF-8");
        ServletOutputStream outStream = servletResponse.getOutputStream();
        InputStream is = null;
        try {
            if (RequestContext.getCurrentContext().getResponseBody() != null) {
                String body = RequestContext.getCurrentContext().getResponseBody();
                this.writeResponse(new ByteArrayInputStream(body.getBytes()), (OutputStream)outStream);
                return;
            }
            boolean isGzipRequested = false;
            String requestEncoding = context.getRequest().getHeader("accept-encoding");
            if (requestEncoding != null && requestEncoding.equals("gzip")) {
                isGzipRequested = true;
            }
            InputStream inputStream = is = context.getResponseDataStream();
            if (is != null && context.sendZuulResponse()) {
                if (context.getResponseGZipped() && !isGzipRequested) {
                    try {
                        inputStream = new GZIPInputStream(is);
                    }
                    catch (ZipException ex) {
                        System.out.println("gzip expected but not received assuming unencoded response" + RequestContext.getCurrentContext().getRequest().getRequestURL().toString());
                        inputStream = is;
                    }
                } else if (context.getResponseGZipped() && isGzipRequested) {
                    servletResponse.setHeader("Content-Encoding", "gzip");
                }
                this.writeResponse(inputStream, (OutputStream)outStream);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                outStream.flush();
                outStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeResponse(InputStream zin, OutputStream out) throws Exception {
        byte[] bytes = new byte[INITIAL_STREAM_BUFFER_SIZE.get()];
        int bytesRead = -1;
        while ((bytesRead = zin.read(bytes)) != -1) {
            try {
                out.write(bytes, 0, bytesRead);
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bytesRead != bytes.length) continue;
            bytes = new byte[bytes.length * 2];
        }
    }

    private void addResponseHeaders() {
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletResponse servletResponse = context.getResponse();
        List zuulResponseHeaders = context.getZuulResponseHeaders();
        List rd = (List)RequestContext.getCurrentContext().get((Object)"routingDebug");
        if (rd != null) {
            StringBuilder debugHeader = new StringBuilder();
            for (String it : rd) {
                debugHeader.append("[[[" + it + "]]]");
            }
            if (INCLUDE_DEBUG_HEADER.get()) {
                servletResponse.addHeader("X-Zuul-Debug-Header", debugHeader.toString());
            }
        }
        if (zuulResponseHeaders != null) {
            for (Pair it : zuulResponseHeaders) {
                servletResponse.addHeader((String)it.first(), (String)it.second());
            }
        }
        RequestContext ctx = RequestContext.getCurrentContext();
        Integer contentLength = ctx.getOriginContentLength();
        if (SET_CONTENT_LENGTH.get() && contentLength != null && !ctx.getResponseGZipped()) {
            servletResponse.setContentLength(contentLength.intValue());
        }
    }
}

