/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="zuul")
public class ZuulProperties {
    private String prefix = "";
    private boolean stripPrefix = true;
    private Boolean retryable;
    private Map<String, ZuulRoute> routes = new LinkedHashMap<String, ZuulRoute>();
    private boolean addProxyHeaders = true;
    private List<String> ignoredServices = new ArrayList<String>();
    private String servletPath = "/zuul";

    @PostConstruct
    public void init() {
        for (Map.Entry<String, ZuulRoute> entry : this.routes.entrySet()) {
            ZuulRoute value = entry.getValue();
            if (!StringUtils.hasText((String)value.getLocation())) {
                value.serviceId = entry.getKey();
            }
            if (!StringUtils.hasText((String)value.getId())) {
                value.id = entry.getKey();
            }
            if (StringUtils.hasText((String)value.getPath())) continue;
            value.path = "/" + entry.getKey() + "/**";
        }
    }

    public String getServletPattern() {
        String path = this.servletPath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.contains("*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isStripPrefix() {
        return this.stripPrefix;
    }

    public Boolean getRetryable() {
        return this.retryable;
    }

    public Map<String, ZuulRoute> getRoutes() {
        return this.routes;
    }

    public boolean isAddProxyHeaders() {
        return this.addProxyHeaders;
    }

    public List<String> getIgnoredServices() {
        return this.ignoredServices;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setStripPrefix(boolean stripPrefix) {
        this.stripPrefix = stripPrefix;
    }

    public void setRetryable(Boolean retryable) {
        this.retryable = retryable;
    }

    public void setRoutes(Map<String, ZuulRoute> routes) {
        this.routes = routes;
    }

    public void setAddProxyHeaders(boolean addProxyHeaders) {
        this.addProxyHeaders = addProxyHeaders;
    }

    public void setIgnoredServices(List<String> ignoredServices) {
        this.ignoredServices = ignoredServices;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZuulProperties)) {
            return false;
        }
        ZuulProperties other = (ZuulProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        if (this.isStripPrefix() != other.isStripPrefix()) {
            return false;
        }
        Boolean this$retryable = this.getRetryable();
        Boolean other$retryable = other.getRetryable();
        if (this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable)) {
            return false;
        }
        Map<String, ZuulRoute> this$routes = this.getRoutes();
        Map<String, ZuulRoute> other$routes = other.getRoutes();
        if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
            return false;
        }
        if (this.isAddProxyHeaders() != other.isAddProxyHeaders()) {
            return false;
        }
        List<String> this$ignoredServices = this.getIgnoredServices();
        List<String> other$ignoredServices = other.getIgnoredServices();
        if (this$ignoredServices == null ? other$ignoredServices != null : !((Object)this$ignoredServices).equals(other$ignoredServices)) {
            return false;
        }
        String this$servletPath = this.getServletPath();
        String other$servletPath = other.getServletPath();
        return !(this$servletPath == null ? other$servletPath != null : !this$servletPath.equals(other$servletPath));
    }

    public boolean canEqual(Object other) {
        return other instanceof ZuulProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 0 : $prefix.hashCode());
        result = result * 59 + (this.isStripPrefix() ? 79 : 97);
        Boolean $retryable = this.getRetryable();
        result = result * 59 + ($retryable == null ? 0 : ((Object)$retryable).hashCode());
        Map<String, ZuulRoute> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 0 : ((Object)$routes).hashCode());
        result = result * 59 + (this.isAddProxyHeaders() ? 79 : 97);
        List<String> $ignoredServices = this.getIgnoredServices();
        result = result * 59 + ($ignoredServices == null ? 0 : ((Object)$ignoredServices).hashCode());
        String $servletPath = this.getServletPath();
        result = result * 59 + ($servletPath == null ? 0 : $servletPath.hashCode());
        return result;
    }

    public String toString() {
        return "ZuulProperties(prefix=" + this.getPrefix() + ", stripPrefix=" + this.isStripPrefix() + ", retryable=" + this.getRetryable() + ", routes=" + this.getRoutes() + ", addProxyHeaders=" + this.isAddProxyHeaders() + ", ignoredServices=" + this.getIgnoredServices() + ", servletPath=" + this.getServletPath() + ")";
    }

    public static class ZuulRoute {
        private String id;
        private String path;
        private String serviceId;
        private String url;
        private boolean stripPrefix = true;
        private Boolean retryable;

        public ZuulRoute(String text) {
            String location = null;
            String path = text;
            if (text.contains("=")) {
                String[] values = StringUtils.trimArrayElements((String[])StringUtils.split((String)text, (String)"="));
                location = values[1];
                path = values[0];
            }
            this.id = this.extractId(path);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.setLocation(location);
            this.path = path;
        }

        public ZuulRoute(String path, String location) {
            this.id = this.extractId(path);
            this.path = path;
            this.setLocation(location);
        }

        public String getLocation() {
            if (StringUtils.hasText((String)this.url)) {
                return this.url;
            }
            return this.serviceId;
        }

        public void setLocation(String location) {
            if (location != null && (location.startsWith("http:") || location.startsWith("https:"))) {
                this.url = location;
            } else {
                this.serviceId = location;
            }
        }

        private String extractId(String path) {
            path = path.startsWith("/") ? path.substring(1) : path;
            path = path.replace("/*", "").replace("*", "");
            return path;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isStripPrefix() {
            return this.stripPrefix;
        }

        public Boolean getRetryable() {
            return this.retryable;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setStripPrefix(boolean stripPrefix) {
            this.stripPrefix = stripPrefix;
        }

        public void setRetryable(Boolean retryable) {
            this.retryable = retryable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZuulRoute)) {
                return false;
            }
            ZuulRoute other = (ZuulRoute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$serviceId = this.getServiceId();
            String other$serviceId = other.getServiceId();
            if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            if (this.isStripPrefix() != other.isStripPrefix()) {
                return false;
            }
            Boolean this$retryable = this.getRetryable();
            Boolean other$retryable = other.getRetryable();
            return !(this$retryable == null ? other$retryable != null : !((Object)this$retryable).equals(other$retryable));
        }

        public boolean canEqual(Object other) {
            return other instanceof ZuulRoute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 0 : $id.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 0 : $path.hashCode());
            String $serviceId = this.getServiceId();
            result = result * 59 + ($serviceId == null ? 0 : $serviceId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 0 : $url.hashCode());
            result = result * 59 + (this.isStripPrefix() ? 79 : 97);
            Boolean $retryable = this.getRetryable();
            result = result * 59 + ($retryable == null ? 0 : ((Object)$retryable).hashCode());
            return result;
        }

        public String toString() {
            return "ZuulProperties.ZuulRoute(id=" + this.getId() + ", path=" + this.getPath() + ", serviceId=" + this.getServiceId() + ", url=" + this.getUrl() + ", stripPrefix=" + this.isStripPrefix() + ", retryable=" + this.getRetryable() + ")";
        }

        @ConstructorProperties(value={"id", "path", "serviceId", "url", "stripPrefix", "retryable"})
        public ZuulRoute(String id, String path, String serviceId, String url, boolean stripPrefix, Boolean retryable) {
            this.id = id;
            this.path = path;
            this.serviceId = serviceId;
            this.url = url;
            this.stripPrefix = stripPrefix;
            this.retryable = retryable;
        }

        public ZuulRoute() {
        }
    }
}

