/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul;

import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.monitoring.MonitoringHelper;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class ZuulFilterInitializer
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ZuulFilterInitializer.class);
    private Map<String, ZuulFilter> filters;

    public ZuulFilterInitializer(Map<String, ZuulFilter> filters) {
        this.filters = filters;
    }

    public void contextInitialized(ServletContextEvent sce) {
        log.info((Object)"Starting filter initializer context listener");
        MonitoringHelper.initMocks();
        FilterRegistry registry = FilterRegistry.instance();
        for (Map.Entry<String, ZuulFilter> entry : this.filters.entrySet()) {
            registry.put(entry.getKey(), entry.getValue());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.info((Object)"Stopping filter initializer context listener");
        FilterRegistry registry = FilterRegistry.instance();
        for (Map.Entry<String, ZuulFilter> entry : this.filters.entrySet()) {
            registry.remove(entry.getKey());
        }
        this.clearLoaderCache();
    }

    private void clearLoaderCache() {
        FilterLoader instance = FilterLoader.getInstance();
        Field field = ReflectionUtils.findField(FilterLoader.class, (String)"hashFiltersByType");
        ReflectionUtils.makeAccessible((Field)field);
        Map cache = (Map)ReflectionUtils.getField((Field)field, (Object)instance);
        cache.clear();
    }
}

