/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.servo;

import com.netflix.servo.monitor.Monitors;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.servo.DefaultServoMetricNaming;
import org.springframework.cloud.netflix.servo.ServoMetricCollector;
import org.springframework.cloud.netflix.servo.ServoMetricNaming;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Monitors.class, MetricReader.class})
@ConditionalOnBean(value={GaugeService.class})
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={MetricRepositoryAutoConfiguration.class})
public class ServoMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServoMetricNaming servoMetricNaming() {
        return new DefaultServoMetricNaming();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServoMetricCollector servoMetricCollector(GaugeService gauges, ServoMetricNaming naming) {
        return new ServoMetricCollector(new ActuatorMetricWriter(gauges), naming);
    }

    private static class ActuatorMetricWriter
    implements MetricWriter {
        private GaugeService gauges;

        public ActuatorMetricWriter(GaugeService gauges) {
            this.gauges = gauges;
        }

        public void increment(Delta<?> delta) {
        }

        public void set(Metric<?> value) {
            this.gauges.submit(value.getName(), value.getValue().doubleValue());
        }

        public void reset(String metricName) {
            this.gauges.submit(metricName, 0.0);
        }
    }
}

