/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.eureka;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.ServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.niws.loadbalancer.NIWSDiscoveryPing;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServerList;
import org.springframework.cloud.netflix.ribbon.eureka.ZoneUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class EurekaRibbonClientConfiguration {
    private static final Log log = LogFactory.getLog(EurekaRibbonClientConfiguration.class);
    @Value(value="${ribbon.eureka.approximateZoneFromHostname:false}")
    private boolean approximateZoneFromHostname = false;
    @Value(value="${ribbon.client.name}")
    private String serviceId = "client";
    protected static final String VALUE_NOT_SET = "__not__set__";
    protected static final String DEFAULT_NAMESPACE = "ribbon";
    @Autowired(required=false)
    private EurekaClientConfig clientConfig;
    @Autowired
    private EurekaInstanceConfigBean eurekaConfig;

    public EurekaRibbonClientConfiguration() {
    }

    public EurekaRibbonClientConfiguration(EurekaClientConfig clientConfig, String serviceId, EurekaInstanceConfigBean eurekaConfig, boolean approximateZoneFromHostname) {
        this.clientConfig = clientConfig;
        this.serviceId = serviceId;
        this.eurekaConfig = eurekaConfig;
        this.approximateZoneFromHostname = approximateZoneFromHostname;
    }

    @Bean
    @ConditionalOnMissingBean
    public IPing ribbonPing(IClientConfig config) {
        NIWSDiscoveryPing ping = new NIWSDiscoveryPing();
        ping.initWithNiwsConfig(config);
        return ping;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(IClientConfig config) {
        DiscoveryEnabledNIWSServerList discoveryServerList = new DiscoveryEnabledNIWSServerList(config);
        DomainExtractingServerList serverList = new DomainExtractingServerList((ServerList<DiscoveryEnabledServer>)discoveryServerList, config, this.approximateZoneFromHostname);
        return serverList;
    }

    @PostConstruct
    public void preprocess() {
        String zone = ConfigurationManager.getDeploymentContext().getValue(DeploymentContext.ContextKey.zone);
        if (this.clientConfig != null && StringUtils.isEmpty((Object)zone)) {
            if (this.approximateZoneFromHostname) {
                String approxZone = ZoneUtils.extractApproximateZone(this.eurekaConfig.getHostname());
                log.debug((Object)("Setting Zone To " + approxZone));
                ConfigurationManager.getDeploymentContext().setValue(DeploymentContext.ContextKey.zone, approxZone);
            } else {
                String availabilityZone;
                String[] zones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
                String string = availabilityZone = zones != null && zones.length > 0 ? zones[0] : null;
                if (availabilityZone != null) {
                    ConfigurationManager.getDeploymentContext().setValue(DeploymentContext.ContextKey.zone, availabilityZone);
                }
            }
        }
        this.setProp(this.serviceId, CommonClientConfigKey.DeploymentContextBasedVipAddresses.key(), this.serviceId);
        this.setProp(this.serviceId, CommonClientConfigKey.EnableZoneAffinity.key(), "true");
    }

    protected void setProp(String serviceId, String suffix, String value) {
        String key = this.getKey(serviceId, suffix);
        DynamicStringProperty property = this.getProperty(key);
        if (property.get().equals(VALUE_NOT_SET)) {
            ConfigurationManager.getConfigInstance().setProperty(key, (Object)value);
        }
    }

    protected DynamicStringProperty getProperty(String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, VALUE_NOT_SET);
    }

    protected String getKey(String serviceId, String suffix) {
        return serviceId + "." + DEFAULT_NAMESPACE + "." + suffix;
    }
}

