/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.servo.monitor.Stopwatch;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerContext;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class RibbonLoadBalancerClient
implements LoadBalancerClient {
    private SpringClientFactory clientFactory;

    public RibbonLoadBalancerClient(SpringClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public URI reconstructURI(ServiceInstance instance, URI original) {
        Assert.notNull((Object)instance, (String)"instance can not be null");
        String serviceId = instance.getServiceId();
        RibbonLoadBalancerContext context = this.clientFactory.getLoadBalancerContext(serviceId);
        Server server = new Server(instance.getHost(), instance.getPort());
        return context.reconstructURIWithServer(server, original);
    }

    public ServiceInstance choose(String serviceId) {
        Server server = this.getServer(serviceId);
        if (server == null) {
            return null;
        }
        return new RibbonServer(serviceId, server);
    }

    public <T> T execute(String serviceId, LoadBalancerRequest<T> request) {
        ILoadBalancer loadBalancer = this.getLoadBalancer(serviceId);
        RibbonLoadBalancerContext context = this.clientFactory.getLoadBalancerContext(serviceId);
        Server server = this.getServer(loadBalancer);
        RibbonServer ribbonServer = new RibbonServer(serviceId, server);
        ServerStats serverStats = context.getServerStats(server);
        context.noteOpenConnection(serverStats);
        Stopwatch tracer = context.getExecuteTracer().start();
        try {
            Object returnVal = request.apply((ServiceInstance)ribbonServer);
            this.recordStats(context, tracer, serverStats, returnVal, null);
            return (T)returnVal;
        }
        catch (Exception ex) {
            this.recordStats(context, tracer, serverStats, null, ex);
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            return null;
        }
    }

    private void recordStats(RibbonLoadBalancerContext context, Stopwatch tracer, ServerStats serverStats, Object entity, Throwable exception) {
        tracer.stop();
        long duration = tracer.getDuration(TimeUnit.MILLISECONDS);
        context.noteRequestCompletion(serverStats, entity, exception, duration, null);
    }

    protected Server getServer(String serviceId) {
        return this.getServer(this.getLoadBalancer(serviceId));
    }

    protected Server getServer(ILoadBalancer loadBalancer) {
        if (loadBalancer == null) {
            return null;
        }
        return loadBalancer.chooseServer((Object)"default");
    }

    protected ILoadBalancer getLoadBalancer(String serviceId) {
        return this.clientFactory.getLoadBalancer(serviceId);
    }

    protected static class RibbonServer
    implements ServiceInstance {
        private String serviceId;
        private Server server;

        protected RibbonServer(String serviceId, Server server) {
            this.serviceId = serviceId;
            this.server = server;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getHost() {
            return this.server.getHost();
        }

        public int getPort() {
            return this.server.getPort();
        }

        public boolean isSecure() {
            return false;
        }

        public URI getUri() {
            return DefaultServiceInstance.getUri((ServiceInstance)this);
        }

        public Server getServer() {
            return this.server;
        }
    }
}

