/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class FeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware {
    private Class<?> type;
    private String name;
    private String url;
    private ApplicationContext context;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.name)) {
            Assert.state((!StringUtils.hasText((String)this.url) ? 1 : 0) != 0, (String)"Either value or url can be specified, but not both");
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    protected Feign.Builder feign() {
        Map requestInterceptors;
        Request.Options options;
        ErrorDecoder errorDecoder;
        Retryer retryer;
        Feign.Builder builder = Feign.builder().logger(this.get(Logger.class)).encoder(this.get(Encoder.class)).decoder(this.get(Decoder.class)).contract(this.get(Contract.class));
        Logger.Level level = this.getOptional(Logger.Level.class);
        if (level != null) {
            builder.logLevel(level);
        }
        if ((retryer = this.getOptional(Retryer.class)) != null) {
            builder.retryer(retryer);
        }
        if ((errorDecoder = this.getOptional(ErrorDecoder.class)) != null) {
            builder.errorDecoder(errorDecoder);
        }
        if ((options = this.getOptional(Request.Options.class)) != null) {
            builder.options(options);
        }
        if ((requestInterceptors = this.context.getBeansOfType(RequestInterceptor.class)) != null) {
            builder.requestInterceptors(requestInterceptors.values());
        }
        return builder;
    }

    protected <T> T get(Class<T> type) {
        return (T)this.context.getBean(type);
    }

    protected <T> T getOptional(Class<T> type) {
        try {
            return (T)this.context.getBean(type);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    protected <T> T loadBalance(Feign.Builder builder, Class<T> type, String schemeName) {
        builder.logger((Logger)new Slf4jLogger(type));
        Client client = this.getOptional(Client.class);
        if (client != null) {
            return (T)builder.client(client).target(type, schemeName);
        }
        throw new IllegalStateException("No Feign Client for loadBalancing defined. Did you forget to include spring-cloud-starter-ribbon?");
    }

    public Object getObject() throws Exception {
        if (StringUtils.hasText((String)this.name) && !this.name.startsWith("http")) {
            this.name = "http://" + this.name;
        }
        if (StringUtils.hasText((String)this.name)) {
            return this.loadBalance(this.feign(), this.type, this.name);
        }
        if (StringUtils.hasText((String)this.url) && !this.url.startsWith("http")) {
            this.url = "http://" + this.url;
        }
        return this.feign().target(this.type, this.url);
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public String toString() {
        return "FeignClientFactoryBean(type=" + this.getType() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", context=" + this.getContext() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignClientFactoryBean)) {
            return false;
        }
        FeignClientFactoryBean other = (FeignClientFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        ApplicationContext this$context = this.getContext();
        ApplicationContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    public boolean canEqual(Object other) {
        return other instanceof FeignClientFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        ApplicationContext $context = this.getContext();
        result = result * 59 + ($context == null ? 0 : $context.hashCode());
        return result;
    }
}

