/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;

public class EurekaHealthIndicator
implements DiscoveryHealthIndicator {
    private final DiscoveryClient discovery;
    private final MetricReader metrics;
    private final EurekaInstanceConfig instanceConfig;
    private int failCount = 0;

    public EurekaHealthIndicator(DiscoveryClient discovery, MetricReader metrics, EurekaInstanceConfig instanceConfig) {
        this.discovery = discovery;
        this.metrics = metrics;
        this.instanceConfig = instanceConfig;
    }

    public String getName() {
        return "eureka";
    }

    public Health health() {
        Health.Builder builder = Health.unknown();
        Status status = this.getStatus(builder);
        return builder.status(status).withDetail("applications", this.getApplications()).build();
    }

    private Status getStatus(Health.Builder builder) {
        Status status = new Status(this.discovery.getInstanceRemoteStatus().toString(), "Remote status from Eureka server");
        Metric value = this.metrics.findOne("counter.servo.discoveryclient_failed");
        if (value != null) {
            int renewalPeriod = this.instanceConfig.getLeaseRenewalIntervalInSeconds();
            int latest = value.getValue().intValue();
            builder.withDetail("failCount", (Object)latest);
            builder.withDetail("renewalPeriod", (Object)renewalPeriod);
            if (this.failCount < latest) {
                status = new Status("UP", "Eureka discovery client is reporting failures");
                this.failCount = latest;
            } else {
                status = new Status("UP", "No new failures in Eureka discovery client");
            }
        }
        return status;
    }

    private Map<String, Object> getApplications() {
        Applications applications = this.discovery.getApplications();
        if (applications == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Application application : applications.getRegisteredApplications()) {
            result.put(application.getName(), application.getInstances().size());
        }
        return result;
    }
}

