/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.JsonXStream;
import com.netflix.discovery.converters.XmlXStream;
import com.thoughtworks.xstream.MarshallingStrategy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.netflix.eureka.DataCenterAwareMarshallingStrategy;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={NoopDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
public class EurekaClientAutoConfiguration
implements ApplicationListener<ParentContextApplicationContextInitializer.ParentContextAvailableEvent> {
    @Autowired
    private ApplicationContext applicationContext;
    private static final ConcurrentMap<String, String> listenerAdded = new ConcurrentHashMap<String, String>();
    @Value(value="${server.port:${SERVER_PORT:${PORT:8080}}}")
    int nonSecurePort;

    @PostConstruct
    public void init() {
        XmlXStream.getInstance().setMarshallingStrategy((MarshallingStrategy)new DataCenterAwareMarshallingStrategy(this.applicationContext));
        JsonXStream.getInstance().setMarshallingStrategy((MarshallingStrategy)new DataCenterAwareMarshallingStrategy(this.applicationContext));
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaClientConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaClientConfigBean eurekaClientConfigBean() {
        return new EurekaClientConfigBean();
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaInstanceConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaInstanceConfigBean eurekaInstanceConfigBean() {
        EurekaInstanceConfigBean instance = new EurekaInstanceConfigBean();
        instance.setNonSecurePort(this.nonSecurePort);
        return instance;
    }

    public void onApplicationEvent(ParentContextApplicationContextInitializer.ParentContextAvailableEvent event) {
        final ConfigurableApplicationContext context = event.getApplicationContext();
        String childId = context.getId();
        ApplicationContext parent = context.getParent();
        if (parent != null && "bootstrap".equals(parent.getId()) && parent instanceof ConfigurableApplicationContext && listenerAdded.putIfAbsent(childId, childId) == null) {
            ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)parent;
            ctx.addApplicationListener((ApplicationListener)new ApplicationListener<HeartbeatEvent>(){

                public void onApplicationEvent(HeartbeatEvent dhe) {
                    context.publishEvent((ApplicationEvent)new ParentHeartbeatEvent(dhe.getSource(), dhe.getValue()));
                }
            });
        }
    }
}

