/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.UniqueIdentifier;
import com.netflix.discovery.converters.Converters;
import com.netflix.discovery.shared.Applications;
import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class DataCenterAwareMarshallingStrategy
implements MarshallingStrategy {
    private TreeMarshallingStrategy delegate = new TreeMarshallingStrategy();
    private ApplicationContext context;

    public DataCenterAwareMarshallingStrategy(ApplicationContext context) {
        this.context = context;
    }

    public Object unmarshal(Object root, HierarchicalStreamReader reader, DataHolder dataHolder, ConverterLookup converterLookup, Mapper mapper) {
        DataCenterAwareConverterLookup wrapped = new DataCenterAwareConverterLookup(converterLookup, this.context);
        return this.delegate.unmarshal(root, reader, dataHolder, (ConverterLookup)wrapped, mapper);
    }

    public void marshal(HierarchicalStreamWriter writer, Object obj, ConverterLookup converterLookup, Mapper mapper, DataHolder dataHolder) {
        DataCenterAwareConverterLookup wrapped = new DataCenterAwareConverterLookup(converterLookup, this.context);
        this.delegate.marshal(writer, obj, (ConverterLookup)wrapped, mapper, dataHolder);
    }

    private static class DataCenterAwareConverter
    extends Converters.InstanceInfoConverter {
        private DataCenterAwareConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            InstanceInfo info = (InstanceInfo)source;
            String instanceId = (String)info.getMetadata().get("instanceId");
            DataCenterInfo dataCenter = info.getDataCenterInfo();
            if (instanceId != null && DataCenterInfo.Name.Amazon != dataCenter.getName()) {
                String old = info.getId();
                String id = old.endsWith(instanceId) ? old : old + ":" + instanceId;
                info = new InstanceInfo.Builder(info).setDataCenterInfo((DataCenterInfo)new InstanceIdDataCenterInfo(id)).build();
                source = info;
            }
            super.marshal(source, writer, context);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Object obj = super.unmarshal(reader, context);
            InstanceInfo info = (InstanceInfo)obj;
            String instanceId = (String)info.getMetadata().get("instanceId");
            DataCenterInfo dataCenter = info.getDataCenterInfo();
            if (instanceId != null && DataCenterInfo.Name.Amazon != dataCenter.getName()) {
                String old = info.getId();
                String id = old.endsWith(instanceId) ? old : old + ":" + instanceId;
                info = new InstanceInfo.Builder(info).setDataCenterInfo((DataCenterInfo)new InstanceIdDataCenterInfo(id)).build();
                obj = info;
            }
            return obj;
        }
    }

    private static class SetVersionInterceptor
    implements MethodInterceptor {
        private static final Log log = LogFactory.getLog(SetVersionInterceptor.class);
        private ApplicationContext context;

        public SetVersionInterceptor(ApplicationContext context) {
            this.context = context;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object ret = invocation.proceed();
            if ("setVersion".equals(invocation.getMethod().getName())) {
                Long version = (Long)Long.class.cast(invocation.getArguments()[0]);
                log.debug((Object)("Applications.setVersion() called with version: " + version));
                this.context.publishEvent((ApplicationEvent)new HeartbeatEvent(invocation.getThis(), (Object)version));
            }
            return ret;
        }
    }

    private static class PublishingApplicationsConverter
    extends Converters.ApplicationsConverter {
        private ApplicationContext context;

        public PublishingApplicationsConverter(ApplicationContext context) {
            this.context = context;
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
            Object obj = super.unmarshal(reader, unmarshallingContext);
            ProxyFactory factory = new ProxyFactory(obj);
            factory.addAdvice((Advice)new SetVersionInterceptor(this.context));
            return factory.getProxy();
        }
    }

    private static class DataCenterAwareConverterLookup
    implements ConverterLookup {
        private ConverterLookup delegate;
        private ApplicationContext context;

        public DataCenterAwareConverterLookup(ConverterLookup delegate, ApplicationContext context) {
            this.delegate = delegate;
            this.context = context;
        }

        public Converter lookupConverterForType(Class type) {
            Converter converter = this.delegate.lookupConverterForType(type);
            if (InstanceInfo.class == type) {
                return new DataCenterAwareConverter();
            }
            if (Applications.class == type) {
                return new PublishingApplicationsConverter(this.context);
            }
            return converter;
        }
    }

    public static class InstanceIdDataCenterInfo
    implements DataCenterInfo,
    UniqueIdentifier {
        private String instanceId;

        public InstanceIdDataCenterInfo(String instanceId) {
            this.instanceId = instanceId;
        }

        public DataCenterInfo.Name getName() {
            return DataCenterInfo.Name.MyOwn;
        }

        public String getId() {
            return this.instanceId;
        }
    }
}

