/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.config;

import com.netflix.discovery.DiscoveryClient;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.ConfigServerProperties;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaInstanceConfigBean.class, DiscoveryClient.class, ConfigServerProperties.class})
public class EurekaClientConfigServerAutoConfiguration {
    @Autowired(required=false)
    private EurekaInstanceConfigBean instance;
    @Autowired(required=false)
    private ConfigServerProperties server;

    @PostConstruct
    public void init() {
        if (this.instance == null || this.server == null) {
            return;
        }
        String prefix = this.server.getPrefix();
        if (StringUtils.hasText((String)prefix)) {
            this.instance.getMetadataMap().put("configPath", prefix);
        }
    }
}

