/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.springframework.cloud.client.ServiceInstance;

class LazyWeightedServiceInstanceList
extends AbstractList<ServiceInstance> {
    private final InterleavedWeightedServiceInstanceSelector selector;
    private volatile int position;
    final ServiceInstance[] expanded;
    private final Object expandingLock = new Object();

    LazyWeightedServiceInstanceList(List<ServiceInstance> instances, int[] weights) {
        int greatestCommonDivisor = 0;
        int total = 0;
        for (int weight : weights) {
            greatestCommonDivisor = LazyWeightedServiceInstanceList.greatestCommonDivisor(greatestCommonDivisor, weight);
            total += weight;
        }
        this.selector = new InterleavedWeightedServiceInstanceSelector(instances.toArray(new ServiceInstance[0]), weights, greatestCommonDivisor);
        this.position = 0;
        this.expanded = new ServiceInstance[total / greatestCommonDivisor];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInstance get(int index) {
        if (index >= this.position) {
            Object object = this.expandingLock;
            synchronized (object) {
                while (this.position <= index && this.position < this.expanded.length) {
                    this.expanded[this.position] = this.selector.next();
                    ++this.position;
                }
            }
        }
        return this.expanded[index];
    }

    @Override
    public int size() {
        return this.expanded.length;
    }

    static int greatestCommonDivisor(int a, int b) {
        while (b != 0) {
            int r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    static class InterleavedWeightedServiceInstanceSelector {
        static final int MODE_LIST = 0;
        static final int MODE_QUEUE = 1;
        final ServiceInstance[] instances;
        final int[] weights;
        final int greatestCommonDivisor;
        final Queue<Entry> queue;
        int mode;
        int position;

        InterleavedWeightedServiceInstanceSelector(ServiceInstance[] instances, int[] weights, int greatestCommonDivisor) {
            this.instances = instances;
            this.weights = weights;
            this.greatestCommonDivisor = greatestCommonDivisor;
            this.queue = new ArrayDeque<Entry>(instances.length);
            this.mode = 0;
            this.position = 0;
        }

        ServiceInstance next() {
            if (this.mode == 0) {
                ServiceInstance instance = this.instances[this.position];
                int weight = this.weights[this.position];
                if ((weight -= this.greatestCommonDivisor) > 0) {
                    this.queue.add(new Entry(instance, weight));
                }
                ++this.position;
                if (this.position == this.instances.length) {
                    this.mode = 1;
                    this.position = 0;
                }
                return instance;
            }
            if (this.queue.isEmpty()) {
                this.mode = 0;
                return this.next();
            }
            Entry entry = this.queue.poll();
            entry.weight -= this.greatestCommonDivisor;
            if (entry.weight > 0) {
                this.queue.add(entry);
            }
            return entry.instance;
        }

        static class Entry {
            final ServiceInstance instance;
            int weight;

            Entry(ServiceInstance instance, int weight) {
                this.instance = instance;
                this.weight = weight;
            }
        }
    }
}

