/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.core.env.Environment;
import reactor.core.publisher.Flux;

public interface ServiceInstanceListSupplier
extends Supplier<Flux<List<ServiceInstance>>> {
    public String getServiceId();

    public static FixedServiceInstanceListSupplier.Builder fixed(Environment environment) {
        return new FixedServiceInstanceListSupplier.Builder(environment);
    }

    public static class FixedServiceInstanceListSupplier
    implements ServiceInstanceListSupplier {
        private final String serviceId;
        private List<ServiceInstance> instances;

        public static Builder with(Environment env) {
            return new Builder(env);
        }

        private FixedServiceInstanceListSupplier(Environment env, List<ServiceInstance> instances) {
            this.serviceId = env.getProperty("loadbalancer.client.name");
            this.instances = instances;
        }

        @Override
        public String getServiceId() {
            return this.serviceId;
        }

        @Override
        public Flux<List<ServiceInstance>> get() {
            return Flux.just(this.instances);
        }

        public static final class Builder {
            private final Environment env;
            private final ArrayList<ServiceInstance> instances = new ArrayList();

            private Builder(Environment env) {
                this.env = env;
            }

            public Builder instance(ServiceInstance instance) {
                this.instances.add(instance);
                return this;
            }

            public Builder instance(int port, String serviceId) {
                return this.instance("localhost", port, serviceId);
            }

            public Builder instance(String host, int port, String serviceId) {
                DefaultServiceInstance instance = new DefaultServiceInstance(this.instanceId(serviceId, host, port), serviceId, host, port, false);
                return this.instance((ServiceInstance)instance);
            }

            private String instanceId(String serviceId, String host, int port) {
                return serviceId + ":" + host + ":" + port;
            }

            public FixedServiceInstanceListSupplier build() {
                return new FixedServiceInstanceListSupplier(this.env, this.instances);
            }
        }
    }
}

