/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class ZonePreferenceServiceInstanceListSupplier
implements ServiceInstanceListSupplier {
    private final String ZONE = "zone";
    private final ServiceInstanceListSupplier delegate;
    private final LoadBalancerProperties loadBalancerProperties;
    private String zone;

    public ZonePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerProperties loadBalancerProperties) {
        this.delegate = delegate;
        this.loadBalancerProperties = loadBalancerProperties;
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.delegate.get()).map(this::filteredByZone);
    }

    private List<ServiceInstance> filteredByZone(List<ServiceInstance> serviceInstances) {
        if (this.zone == null) {
            this.zone = this.loadBalancerProperties.getZone();
        }
        if (this.zone != null) {
            ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>();
            for (ServiceInstance serviceInstance : serviceInstances) {
                String instanceZone = this.getZone(serviceInstance);
                if (!this.zone.equalsIgnoreCase(instanceZone)) continue;
                filteredInstances.add(serviceInstance);
            }
            if (filteredInstances.size() > 0) {
                return filteredInstances;
            }
        }
        return serviceInstances;
    }

    private String getZone(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            return (String)metadata.get("zone");
        }
        return null;
    }
}

