/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.LazilyInstantiate;
import org.springframework.cloud.kubernetes.PodUtils;

public class StandardPodUtils
implements PodUtils {
    public static final String HOSTNAME = "HOSTNAME";
    private static final Log LOG = LogFactory.getLog(StandardPodUtils.class);
    private final KubernetesClient client;
    private final String hostName;
    private Supplier<Pod> current;

    public StandardPodUtils(KubernetesClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Must provide an instance of KubernetesClient");
        }
        this.client = client;
        this.hostName = System.getenv(HOSTNAME);
        this.current = LazilyInstantiate.using(() -> this.internalGetPod());
    }

    @Override
    public Supplier<Pod> currentPod() {
        return this.current;
    }

    @Override
    public Boolean isInsideKubernetes() {
        return this.currentPod().get() != null;
    }

    private synchronized Pod internalGetPod() {
        try {
            if (this.isServiceAccountFound() && this.isHostNameEnvVarPresent()) {
                return (Pod)((PodResource)this.client.pods().withName(this.hostName)).get();
            }
            return null;
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to get pod with name:[" + this.hostName + "]. You should look into this if things aren't working as you expect. Are you missing serviceaccount permissions?"), t);
            return null;
        }
    }

    private boolean isHostNameEnvVarPresent() {
        return this.hostName != null && !this.hostName.isEmpty();
    }

    private boolean isServiceAccountFound() {
        return Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]).toFile().exists() && Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0]).toFile().exists();
    }
}

