/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.kubernetes.PodUtils;

public class KubernetesHealthIndicator
extends AbstractHealthIndicator {
    private PodUtils utils;

    public KubernetesHealthIndicator(PodUtils utils) {
        this.utils = utils;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            Pod current = this.utils.currentPod().get();
            if (current != null) {
                builder.up().withDetail("inside", (Object)true).withDetail("namespace", (Object)current.getMetadata().getNamespace()).withDetail("podName", (Object)current.getMetadata().getName()).withDetail("podIp", (Object)current.getStatus().getPodIP()).withDetail("serviceAccount", (Object)current.getSpec().getServiceAccountName()).withDetail("nodeName", (Object)current.getSpec().getNodeName()).withDetail("hostIp", (Object)current.getStatus().getHostIP());
            } else {
                builder.up().withDetail("inside", (Object)false);
            }
        }
        catch (Exception e) {
            builder.down((Throwable)e);
        }
    }
}

