/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config.conditional;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.config.conditional.ConditionalOnEnabledPredicate;
import org.springframework.cloud.gateway.config.conditional.OnEnabledComponent;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.support.NameUtils;
import org.springframework.web.server.ServerWebExchange;

public class OnEnabledPredicate
extends OnEnabledComponent<RoutePredicateFactory<?>> {
    @Override
    protected String normalizeComponentName(Class<? extends RoutePredicateFactory<?>> predicateClass) {
        return "predicate." + NameUtils.normalizeRoutePredicateNameAsProperty(predicateClass);
    }

    @Override
    protected Class<?> annotationClass() {
        return ConditionalOnEnabledPredicate.class;
    }

    @Override
    protected Class<? extends RoutePredicateFactory<?>> defaultValueClass() {
        return DefaultValue.class;
    }

    static class DefaultValue
    implements RoutePredicateFactory<Object> {
        DefaultValue() {
        }

        @Override
        public Predicate<ServerWebExchange> apply(Consumer<Object> consumer) {
            throw new UnsupportedOperationException("class DefaultValue is never meant to be intantiated");
        }

        @Override
        public Predicate<ServerWebExchange> apply(Object config) {
            throw new UnsupportedOperationException("class DefaultValue is never meant to be intantiated");
        }
    }
}

