/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerWebExchangeUtils {
    private static final Log logger = LogFactory.getLog(ServerWebExchangeUtils.class);
    public static final String PRESERVE_HOST_HEADER_ATTRIBUTE = ServerWebExchangeUtils.qualify("preserveHostHeader");
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = ServerWebExchangeUtils.qualify("uriTemplateVariables");
    public static final String CLIENT_RESPONSE_ATTR = ServerWebExchangeUtils.qualify("webHandlerClientResponse");
    public static final String GATEWAY_ROUTE_ATTR = ServerWebExchangeUtils.qualify("gatewayRoute");
    public static final String GATEWAY_REQUEST_URL_ATTR = ServerWebExchangeUtils.qualify("gatewayRequestUrl");
    public static final String GATEWAY_ORIGINAL_REQUEST_URL_ATTR = ServerWebExchangeUtils.qualify("gatewayOriginalRequestUrl");
    public static final String GATEWAY_HANDLER_MAPPER_ATTR = ServerWebExchangeUtils.qualify("gatewayHandlerMapper");
    public static final String GATEWAY_SCHEME_PREFIX_ATTR = ServerWebExchangeUtils.qualify("gatewaySchemePrefix");
    public static final String GATEWAY_PREDICATE_ROUTE_ATTR = ServerWebExchangeUtils.qualify("gatewayPredicateRouteAttr");
    public static final String WEIGHT_ATTR = ServerWebExchangeUtils.qualify("routeWeight");
    public static final String ORIGINAL_RESPONSE_CONTENT_TYPE_ATTR = "original_response_content_type";
    public static final String GATEWAY_ALREADY_ROUTED_ATTR = ServerWebExchangeUtils.qualify("gatewayAlreadyRouted");
    public static final String GATEWAY_ALREADY_PREFIXED_ATTR = ServerWebExchangeUtils.qualify("gatewayAlreadyPrefixed");

    private static String qualify(String attr) {
        return ServerWebExchangeUtils.class.getName() + "." + attr;
    }

    public static void setAlreadyRouted(ServerWebExchange exchange) {
        exchange.getAttributes().put(GATEWAY_ALREADY_ROUTED_ATTR, true);
    }

    public static boolean isAlreadyRouted(ServerWebExchange exchange) {
        return (Boolean)exchange.getAttributeOrDefault(GATEWAY_ALREADY_ROUTED_ATTR, (Object)false);
    }

    public static boolean setResponseStatus(ServerWebExchange exchange, HttpStatus httpStatus) {
        boolean response = exchange.getResponse().setStatusCode(httpStatus);
        if (!response && logger.isWarnEnabled()) {
            logger.warn((Object)("Unable to set status code to " + httpStatus + ". Response already committed."));
        }
        return response;
    }

    public static boolean containsEncodedParts(URI uri) {
        boolean encoded = uri.getRawQuery() != null && uri.getRawQuery().contains("%") || uri.getPath() != null && uri.getRawPath().contains("%");
        return encoded;
    }

    public static HttpStatus parse(String statusString) {
        HttpStatus httpStatus;
        try {
            int status = Integer.parseInt(statusString);
            httpStatus = HttpStatus.resolve((int)status);
        }
        catch (NumberFormatException e) {
            httpStatus = HttpStatus.valueOf((String)statusString.toUpperCase());
        }
        return httpStatus;
    }

    public static void addOriginalRequestUrl(ServerWebExchange exchange, URI url) {
        exchange.getAttributes().computeIfAbsent(GATEWAY_ORIGINAL_REQUEST_URL_ATTR, s -> new LinkedHashSet());
        LinkedHashSet uris = (LinkedHashSet)exchange.getRequiredAttribute(GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        uris.add(url);
    }

    public static AsyncPredicate<ServerWebExchange> toAsyncPredicate(Predicate<? super ServerWebExchange> predicate) {
        Objects.requireNonNull(predicate, "predicate must not be null");
        return t -> Mono.just((Object)predicate.test((ServerWebExchange)t));
    }
}

