/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactory;
import org.springframework.web.server.ServerWebExchange;

public class AfterRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String DATETIME_KEY = "datetime";

    public AfterRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList(DATETIME_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        ZonedDateTime datetime = BetweenRoutePredicateFactory.getZonedDateTime(config.getDatetime());
        return exchange -> {
            ZonedDateTime now = ZonedDateTime.now();
            return now.isAfter(datetime);
        };
    }

    public static class Config {
        private String datetime;

        public String getDatetime() {
            return this.datetime;
        }

        public void setDatetime(String datetime) {
            this.datetime = datetime;
        }
    }
}

