/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.util.UriTemplate;
import org.springframework.web.util.pattern.PathPattern;

public class SetPathGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String TEMPLATE_KEY = "template";

    public SetPathGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(TEMPLATE_KEY);
    }

    @Override
    public GatewayFilter apply(Config config) {
        UriTemplate uriTemplate = new UriTemplate(config.template);
        return (exchange, chain) -> {
            PathPattern.PathMatchInfo variables = (PathPattern.PathMatchInfo)exchange.getAttribute(ServerWebExchangeUtils.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            ServerHttpRequest req = exchange.getRequest();
            ServerWebExchangeUtils.addOriginalRequestUrl(exchange, req.getURI());
            Map uriVariables = variables != null ? variables.getUriVariables() : Collections.emptyMap();
            URI uri = uriTemplate.expand(uriVariables);
            String newPath = uri.getRawPath();
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
            ServerHttpRequest request = req.mutate().path(newPath).build();
            return chain.filter(exchange.mutate().request(request).build());
        };
    }

    public static class Config {
        private String template;

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }
}

