/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.Subscription;

public class HystrixGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String FALLBACK_URI = "fallbackUri";
    private final ObjectProvider<DispatcherHandler> dispatcherHandler;

    public HystrixGatewayFilterFactory(ObjectProvider<DispatcherHandler> dispatcherHandler) {
        super(Config.class);
        this.dispatcherHandler = dispatcherHandler;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    public GatewayFilter apply(String routeId, Consumer<Config> consumer) {
        Config config = (Config)this.newConfig();
        consumer.accept(config);
        if (StringUtils.isEmpty((Object)config.getName()) && !StringUtils.isEmpty((Object)routeId)) {
            config.setName(routeId);
        }
        return this.apply(config);
    }

    @Override
    public GatewayFilter apply(Config config) {
        if (config.setter == null) {
            Assert.notNull((Object)config.name, (String)"A name must be supplied for the Hystrix Command Key");
            HystrixCommandGroupKey groupKey = HystrixCommandGroupKey.Factory.asKey((String)this.getClass().getSimpleName());
            HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)config.name);
            config.setter = HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)groupKey).andCommandKey(commandKey);
        }
        return (exchange, chain) -> {
            RouteHystrixCommand command = new RouteHystrixCommand(config.setter, config.fallbackUri, exchange, chain);
            return Mono.create(s -> {
                Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
                s.onCancel(() -> ((Subscription)sub).unsubscribe());
            }).onErrorResume(throwable -> {
                if (throwable instanceof HystrixRuntimeException) {
                    HystrixRuntimeException e = (HystrixRuntimeException)throwable;
                    HystrixRuntimeException.FailureType failureType = e.getFailureType();
                    switch (failureType) {
                        case TIMEOUT: {
                            return Mono.error((Throwable)new TimeoutException());
                        }
                        case COMMAND_EXCEPTION: {
                            Throwable cause = e.getCause();
                            if (!(cause instanceof ResponseStatusException) && AnnotatedElementUtils.findMergedAnnotation(cause.getClass(), ResponseStatus.class) == null) break;
                            return Mono.error((Throwable)cause);
                        }
                    }
                }
                return Mono.error((Throwable)throwable);
            }).then();
        };
    }

    public static class Config {
        private String name;
        private HystrixObservableCommand.Setter setter;
        private URI fallbackUri;

        public String getName() {
            return this.name;
        }

        public Config setName(String name) {
            this.name = name;
            return this;
        }

        public Config setFallbackUri(String fallbackUri) {
            if (fallbackUri != null) {
                this.setFallbackUri(URI.create(fallbackUri));
            }
            return this;
        }

        public URI getFallbackUri() {
            return this.fallbackUri;
        }

        public void setFallbackUri(URI fallbackUri) {
            if (fallbackUri != null && !"forward".equals(fallbackUri.getScheme())) {
                throw new IllegalArgumentException("Hystrix Filter currently only supports 'forward' URIs, found " + fallbackUri);
            }
            this.fallbackUri = fallbackUri;
        }

        public Config setSetter(HystrixObservableCommand.Setter setter) {
            this.setter = setter;
            return this;
        }
    }

    private class RouteHystrixCommand
    extends HystrixObservableCommand<Void> {
        private final URI fallbackUri;
        private final ServerWebExchange exchange;
        private final GatewayFilterChain chain;

        RouteHystrixCommand(HystrixObservableCommand.Setter setter, URI fallbackUri, ServerWebExchange exchange, GatewayFilterChain chain) {
            super(setter);
            this.fallbackUri = fallbackUri;
            this.exchange = exchange;
            this.chain = chain;
        }

        protected Observable<Void> construct() {
            return RxReactiveStreams.toObservable(this.chain.filter(this.exchange));
        }

        protected Observable<Void> resumeWithFallback() {
            if (this.fallbackUri == null) {
                return super.resumeWithFallback();
            }
            URI uri = this.exchange.getRequest().getURI();
            boolean encoded = ServerWebExchangeUtils.containsEncodedParts(uri);
            URI requestUrl = UriComponentsBuilder.fromUri((URI)uri).host(null).port(null).uri(this.fallbackUri).build(encoded).toUri();
            this.exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUrl);
            ServerHttpRequest request = this.exchange.getRequest().mutate().uri(requestUrl).build();
            ServerWebExchange mutated = this.exchange.mutate().request(request).build();
            DispatcherHandler dispatcherHandler = (DispatcherHandler)HystrixGatewayFilterFactory.this.dispatcherHandler.getIfAvailable();
            return RxReactiveStreams.toObservable((Publisher)dispatcherHandler.handle(mutated));
        }
    }
}

