/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public interface ShortcutConfigurable {
    public static String normalizeKey(String key, int entryIdx, ShortcutConfigurable argHints, Map<String, String> args) {
        if (key.startsWith("_genkey_") && !argHints.shortcutFieldOrder().isEmpty() && entryIdx < args.size() && entryIdx < argHints.shortcutFieldOrder().size()) {
            key = argHints.shortcutFieldOrder().get(entryIdx);
        }
        return key;
    }

    public static Object getValue(SpelExpressionParser parser, BeanFactory beanFactory, String entryValue) {
        Object value;
        String rawValue = entryValue;
        if (rawValue != null) {
            rawValue = rawValue.trim();
        }
        if (rawValue != null && rawValue.startsWith("#{") && entryValue.endsWith("}")) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
            Expression expression = parser.parseExpression(entryValue, (ParserContext)new TemplateParserContext());
            value = expression.getValue((EvaluationContext)context);
        } else {
            value = entryValue;
        }
        return value;
    }

    default public ShortcutType shortcutType() {
        return ShortcutType.DEFAULT;
    }

    default public List<String> shortcutFieldOrder() {
        return Collections.emptyList();
    }

    default public String shortcutFieldPrefix() {
        return "";
    }

    public static enum ShortcutType {
        DEFAULT{

            @Override
            public Map<String, Object> normalize(Map<String, String> args, ShortcutConfigurable shortcutConf, SpelExpressionParser parser, BeanFactory beanFactory) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int entryIdx = 0;
                for (Map.Entry<String, String> entry : args.entrySet()) {
                    String key = ShortcutConfigurable.normalizeKey(entry.getKey(), entryIdx, shortcutConf, args);
                    Object value = ShortcutConfigurable.getValue(parser, beanFactory, entry.getValue());
                    map.put(key, value);
                    ++entryIdx;
                }
                return map;
            }
        }
        ,
        GATHER_LIST{

            @Override
            public Map<String, Object> normalize(Map<String, String> args, ShortcutConfigurable shortcutConf, SpelExpressionParser parser, BeanFactory beanFactory) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<String> fieldOrder = shortcutConf.shortcutFieldOrder();
                Assert.isTrue((fieldOrder != null && fieldOrder.size() == 1 ? 1 : 0) != 0, (String)"Shortcut Configuration Type GATHER_LIST must have shortcutFieldOrder of size 1");
                String fieldName = fieldOrder.get(0);
                map.put(fieldName, args.values().stream().map(value -> ShortcutConfigurable.getValue(parser, beanFactory, value)).collect(Collectors.toList()));
                return map;
            }
        };


        public abstract Map<String, Object> normalize(Map<String, String> var1, ShortcutConfigurable var2, SpelExpressionParser var3, BeanFactory var4);
    }
}

