/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Collection;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

@ConfigurationProperties(value="spring.cloud.gateway.x-forwarded")
public class XForwardedHeadersFilter
implements HttpHeadersFilter,
Ordered {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    private int order = 0;
    private boolean enabled = true;
    private boolean forEnabled = true;
    private boolean hostEnabled = true;
    private boolean portEnabled = true;
    private boolean protoEnabled = true;
    private boolean forAppend = true;
    private boolean hostAppend = true;
    private boolean portAppend = true;
    private boolean protoAppend = true;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isForEnabled() {
        return this.forEnabled;
    }

    public void setForEnabled(boolean forEnabled) {
        this.forEnabled = forEnabled;
    }

    public boolean isHostEnabled() {
        return this.hostEnabled;
    }

    public void setHostEnabled(boolean hostEnabled) {
        this.hostEnabled = hostEnabled;
    }

    public boolean isPortEnabled() {
        return this.portEnabled;
    }

    public void setPortEnabled(boolean portEnabled) {
        this.portEnabled = portEnabled;
    }

    public boolean isProtoEnabled() {
        return this.protoEnabled;
    }

    public void setProtoEnabled(boolean protoEnabled) {
        this.protoEnabled = protoEnabled;
    }

    public boolean isForAppend() {
        return this.forAppend;
    }

    public void setForAppend(boolean forAppend) {
        this.forAppend = forAppend;
    }

    public boolean isHostAppend() {
        return this.hostAppend;
    }

    public void setHostAppend(boolean hostAppend) {
        this.hostAppend = hostAppend;
    }

    public boolean isPortAppend() {
        return this.portAppend;
    }

    public void setPortAppend(boolean portAppend) {
        this.portAppend = portAppend;
    }

    public boolean isProtoAppend() {
        return this.protoAppend;
    }

    public void setProtoAppend(boolean protoAppend) {
        this.protoAppend = protoAppend;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        original.entrySet().stream().forEach(entry -> updated.addAll((String)entry.getKey(), (List)entry.getValue()));
        if (this.isForEnabled() && request.getRemoteAddress() != null && request.getRemoteAddress().getAddress() != null) {
            String remoteAddr = request.getRemoteAddress().getAddress().getHostAddress();
            List xforwarded = original.get((Object)X_FORWARDED_FOR_HEADER);
            if (!(remoteAddr == null || xforwarded != null && xforwarded.contains(remoteAddr))) {
                this.write(updated, X_FORWARDED_FOR_HEADER, remoteAddr, this.isForAppend());
            }
        }
        String proto = request.getURI().getScheme();
        if (this.isProtoEnabled()) {
            this.write(updated, X_FORWARDED_PROTO_HEADER, proto, this.isProtoAppend());
        }
        if (this.isPortEnabled()) {
            String port = String.valueOf(request.getURI().getPort());
            if (request.getURI().getPort() < 0) {
                port = String.valueOf(this.getDefaultPort(proto));
            }
            this.write(updated, X_FORWARDED_PORT_HEADER, port, this.isPortAppend());
        }
        if (this.isHostEnabled()) {
            String host = this.toHostHeader(request);
            this.write(updated, X_FORWARDED_HOST_HEADER, host, this.isHostAppend());
        }
        return updated;
    }

    private void write(HttpHeaders headers, String name, String value, boolean append) {
        if (append) {
            headers.add(name, value);
            List values = headers.get((Object)name);
            String delimitedValue = StringUtils.collectionToCommaDelimitedString((Collection)values);
            headers.set(name, delimitedValue);
        } else {
            headers.set(name, value);
        }
    }

    private int getDefaultPort(String scheme) {
        return HTTPS_SCHEME.equals(scheme) ? 443 : 80;
    }

    private boolean hasHeader(ServerHttpRequest request, String name) {
        HttpHeaders headers = request.getHeaders();
        return headers.containsKey((Object)name) && StringUtils.hasLength((String)headers.getFirst(name));
    }

    private String toHostHeader(ServerHttpRequest request) {
        int port = request.getURI().getPort();
        String host = request.getURI().getHost();
        String scheme = request.getURI().getScheme();
        if (port < 0 || port == 80 && HTTP_SCHEME.equals(scheme) || port == 443 && HTTPS_SCHEME.equals(scheme)) {
            return host;
        }
        return host + ":" + port;
    }
}

