/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import reactor.core.publisher.Mono;

public class SetStatusGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String STATUS_KEY = "status";

    public SetStatusGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(STATUS_KEY);
    }

    @Override
    public GatewayFilter apply(Config config) {
        HttpStatus status = ServerWebExchangeUtils.parse(config.status);
        Integer intStatus = status == null ? Integer.valueOf(Integer.parseInt(config.status)) : null;
        return (exchange, chain) -> chain.filter(exchange).then(Mono.fromRunnable(() -> {
            if (!exchange.getResponse().isCommitted()) {
                if (status != null) {
                    ServerWebExchangeUtils.setResponseStatus(exchange, status);
                } else if (intStatus != null && exchange.getResponse() instanceof AbstractServerHttpResponse) {
                    ((AbstractServerHttpResponse)exchange.getResponse()).setStatusCodeValue(intStatus);
                }
            }
        }));
    }

    public static class Config {
        private String status;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

