/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ResourceUtils;
import reactor.ipc.netty.resources.PoolResources;

@ConfigurationProperties(value="spring.cloud.gateway.httpclient")
public class HttpClientProperties {
    private Integer connectTimeout;
    private Duration responseTimeout;
    private Pool pool = new Pool();
    private Proxy proxy = new Proxy();
    private Ssl ssl = new Ssl();

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public String toString() {
        return "HttpClientProperties{connectTimeout=" + this.connectTimeout + ", responseTimeout=" + this.responseTimeout + ", pool=" + this.pool + ", proxy=" + this.proxy + ", ssl=" + this.ssl + '}';
    }

    public class Ssl {
        private boolean useInsecureTrustManager = false;
        private List<String> trustedX509Certificates = new ArrayList<String>();

        public List<String> getTrustedX509Certificates() {
            return this.trustedX509Certificates;
        }

        public X509Certificate[] getTrustedX509CertificatesForTrustManager() {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                for (String trustedCert : HttpClientProperties.this.ssl.getTrustedX509Certificates()) {
                    try {
                        URL url = ResourceUtils.getURL((String)trustedCert);
                        X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(url.openStream());
                        certs.add(cert);
                    }
                    catch (IOException e) {
                        throw new WebServerException("Could not load certificate '" + trustedCert + "'", (Throwable)e);
                    }
                }
                return certs.toArray(new X509Certificate[certs.size()]);
            }
            catch (CertificateException e1) {
                throw new WebServerException("Could not load CertificateFactory X.509", (Throwable)e1);
            }
        }

        public void setTrustedX509Certificates(List<String> trustedX509) {
            this.trustedX509Certificates = trustedX509;
        }

        public boolean isUseInsecureTrustManager() {
            return this.useInsecureTrustManager;
        }

        public void setUseInsecureTrustManager(boolean useInsecureTrustManager) {
            this.useInsecureTrustManager = useInsecureTrustManager;
        }

        public String toString() {
            return "Ssl {useInsecureTrustManager=" + this.useInsecureTrustManager + ", trustedX509Certificates=" + this.trustedX509Certificates + "}";
        }
    }

    public class Proxy {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String nonProxyHostsPattern;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getNonProxyHostsPattern() {
            return this.nonProxyHostsPattern;
        }

        public void setNonProxyHostsPattern(String nonProxyHostsPattern) {
            this.nonProxyHostsPattern = nonProxyHostsPattern;
        }

        public String toString() {
            return "Proxy{host='" + this.host + '\'' + ", port=" + this.port + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", nonProxyHostsPattern='" + this.nonProxyHostsPattern + '\'' + '}';
        }
    }

    public static class Pool {
        private PoolType type = PoolType.ELASTIC;
        private String name = "proxy";
        private Integer maxConnections = PoolResources.DEFAULT_POOL_MAX_CONNECTION;
        private Long acquireTimeout = PoolResources.DEFAULT_POOL_ACQUIRE_TIMEOUT;

        public PoolType getType() {
            return this.type;
        }

        public void setType(PoolType type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public Long getAcquireTimeout() {
            return this.acquireTimeout;
        }

        public void setAcquireTimeout(Long acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
        }

        public String toString() {
            return "Pool{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", maxConnections=" + this.maxConnections + ", acquireTimeout=" + this.acquireTimeout + '}';
        }

        public static enum PoolType {
            ELASTIC,
            FIXED,
            DISABLED;

        }
    }
}

