/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import org.springframework.cloud.function.json.JsonMapper;

public class JacksonMapper
implements JsonMapper {
    private final ObjectMapper mapper;

    public JacksonMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> T toObject(String json, Type type) {
        try {
            return (T)this.mapper.readValue(json, TypeFactory.defaultInstance().constructType(type));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert JSON " + json, e);
        }
    }

    @Override
    public String toString(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot convert to JSON", e);
        }
    }
}

