/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.ServiceConnectorCreatorRegistry;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.service.CompositeServiceInfo;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorCreator;
import org.springframework.cloud.service.ServiceInfo;

public class Cloud {
    private CloudConnector cloudConnector;
    private ServiceConnectorCreatorRegistry serviceConnectorCreatorRegistry = new ServiceConnectorCreatorRegistry();

    Cloud(CloudConnector cloudConnector, List<ServiceConnectorCreator<?, ? extends ServiceInfo>> serviceConnectorCreators) {
        this.cloudConnector = cloudConnector;
        for (ServiceConnectorCreator<?, ServiceInfo> serviceConnectorCreator : serviceConnectorCreators) {
            this.registerServiceConnectorCreator(serviceConnectorCreator);
        }
    }

    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        return this.cloudConnector.getApplicationInstanceInfo();
    }

    public ServiceInfo getServiceInfo(String serviceId) {
        for (ServiceInfo serviceInfo : this.getServiceInfos()) {
            if (!serviceInfo.getId().equals(serviceId)) continue;
            return serviceInfo;
        }
        throw new CloudException("No service with id " + serviceId + " found");
    }

    public List<ServiceInfo> getServiceInfos() {
        return Cloud.flatten(this.cloudConnector.getServiceInfos());
    }

    public <T> List<ServiceInfo> getServiceInfos(Class<T> serviceConnectorType) {
        List<ServiceInfo> allServiceInfos = this.getServiceInfos();
        ArrayList<ServiceInfo> matchingServiceInfos = new ArrayList<ServiceInfo>();
        for (ServiceInfo serviceInfo : allServiceInfos) {
            if (!this.serviceConnectorCreatorRegistry.canCreate(serviceConnectorType, serviceInfo)) continue;
            matchingServiceInfos.add(serviceInfo);
        }
        return matchingServiceInfos;
    }

    public <SC> SC getServiceConnector(String serviceId, Class<SC> serviceConnectorType, ServiceConnectorConfig serviceConnectorConfig) {
        ServiceInfo serviceInfo = this.getServiceInfo(serviceId);
        return this.getServiceConnector(serviceInfo, serviceConnectorType, serviceConnectorConfig);
    }

    public <SC> SC getSingletonServiceConnector(Class<SC> serviceConnectorType, ServiceConnectorConfig serviceConnectorConfig) {
        List<ServiceInfo> matchingServiceInfos = this.getServiceInfos(serviceConnectorType);
        if (matchingServiceInfos.size() != 1) {
            throw new CloudException("No unique service matching " + serviceConnectorType + " found. Expected 1, found " + matchingServiceInfos.size());
        }
        ServiceInfo matchingServiceInfo = matchingServiceInfos.get(0);
        return this.getServiceConnector(matchingServiceInfo, serviceConnectorType, serviceConnectorConfig);
    }

    public void registerServiceConnectorCreator(ServiceConnectorCreator<?, ? extends ServiceInfo> serviceConnectorCreator) {
        this.serviceConnectorCreatorRegistry.registerCreator(serviceConnectorCreator);
    }

    public Properties getCloudProperties() {
        HashMap<String, ArrayList<ServiceInfo>> mappedServiceInfos = new HashMap<String, ArrayList<ServiceInfo>>();
        for (ServiceInfo serviceInfo : this.getServiceInfos()) {
            String key = Cloud.getServiceLabel(serviceInfo);
            ArrayList<ServiceInfo> serviceInfosForLabel = (ArrayList<ServiceInfo>)mappedServiceInfos.get(key);
            if (serviceInfosForLabel == null) {
                serviceInfosForLabel = new ArrayList<ServiceInfo>();
                mappedServiceInfos.put(key, serviceInfosForLabel);
            }
            serviceInfosForLabel.add(serviceInfo);
        }
        String servicePropKeyLead = "cloud.services.";
        Properties cloudProperties = new Properties();
        for (Map.Entry mappedServiceInfo : mappedServiceInfos.entrySet()) {
            List serviceInfos = (List)mappedServiceInfo.getValue();
            for (ServiceInfo serviceInfo : serviceInfos) {
                String idBasedKey = "cloud.services." + serviceInfo.getId();
                cloudProperties.putAll((Map<?, ?>)this.getServiceProperties(idBasedKey, serviceInfo));
                if (serviceInfos.size() != 1) continue;
                String labelBasedKey = "cloud.services." + (String)mappedServiceInfo.getKey();
                cloudProperties.putAll((Map<?, ?>)this.getServiceProperties(labelBasedKey, serviceInfo));
            }
        }
        cloudProperties.putAll((Map<?, ?>)this.getAppProperties());
        return cloudProperties;
    }

    private <SC> SC getServiceConnector(ServiceInfo serviceInfo, Class<SC> serviceConnectorType, ServiceConnectorConfig serviceConnectorConfig) {
        ServiceConnectorCreator<SC, ServiceInfo> serviceConnectorCreator = this.serviceConnectorCreatorRegistry.getServiceCreator(serviceConnectorType, serviceInfo);
        return serviceConnectorCreator.create(serviceInfo, serviceConnectorConfig);
    }

    private Properties getAppProperties() {
        String appPropLeadKey = "cloud.application.";
        Properties appProperties = new Properties();
        appProperties.put("cloud.application.instance-id", this.getApplicationInstanceInfo().getInstanceId());
        appProperties.put("cloud.application.app-id", this.getApplicationInstanceInfo().getAppId());
        for (Map.Entry<String, Object> entry : this.getApplicationInstanceInfo().getProperties().entrySet()) {
            if (entry.getValue() == null) continue;
            appProperties.put("cloud.application." + entry.getKey(), entry.getValue());
        }
        return appProperties;
    }

    private Properties getServiceProperties(String keyLead, ServiceInfo serviceInfo) {
        Properties cloudProperties = new Properties();
        try {
            PropertyDescriptor[] propDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(serviceInfo.getClass());
            for (PropertyDescriptor propDescriptor : propDescriptors = beanInfo.getPropertyDescriptors()) {
                ServiceInfo.ServiceProperty propAnnotation = propDescriptor.getReadMethod().getAnnotation(ServiceInfo.ServiceProperty.class);
                String key = keyLead;
                if (propAnnotation == null) continue;
                if (!propAnnotation.category().isEmpty()) {
                    key = key + "." + propAnnotation.category();
                }
                key = !propAnnotation.name().isEmpty() ? key + "." + propAnnotation.name() : key + "." + propDescriptor.getName().toLowerCase();
                Object value = propDescriptor.getReadMethod().invoke((Object)serviceInfo, new Object[0]);
                if (value == null) continue;
                cloudProperties.put(key, value);
            }
        }
        catch (Exception e) {
            throw new CloudException(e);
        }
        return cloudProperties;
    }

    private static String getServiceLabel(ServiceInfo serviceInfo) {
        Class<?> serviceInfoClass = serviceInfo.getClass();
        ServiceInfo.ServiceLabel labelAnnotation = serviceInfoClass.getAnnotation(ServiceInfo.ServiceLabel.class);
        if (labelAnnotation == null) {
            return null;
        }
        return labelAnnotation.value();
    }

    private static List<ServiceInfo> flatten(List<ServiceInfo> serviceInfos) {
        ArrayList<ServiceInfo> flattened = new ArrayList<ServiceInfo>();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (serviceInfo instanceof CompositeServiceInfo) {
                CompositeServiceInfo compositeServiceInfo = (CompositeServiceInfo)serviceInfo;
                flattened.addAll(Cloud.flatten(compositeServiceInfo.getServiceInfos()));
                continue;
            }
            flattened.add(serviceInfo);
        }
        return flattened;
    }
}

