/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletMultipartAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.mock.web.MockHttpServletRequest;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.ImmutableMultimap;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.collect.Maps;
import wiremock.com.google.common.io.ByteStreams;
import wiremock.org.eclipse.jetty.util.MultiPartInputStreamParser;

class WireMockHttpServletRequestAdapter
implements Request {
    private static final String ORIGINAL_REQUEST_KEY = "wiremock.ORIGINAL_REQUEST";
    private final HttpServletRequest request;
    private byte[] cachedBody;
    private Collection<Request.Part> cachedMultiparts;

    WireMockHttpServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!wiremock.com.google.common.base.Strings.isNullOrEmpty((String)contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (wiremock.com.google.common.base.Strings.isNullOrEmpty((String)this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    public RequestMethod getMethod() {
        return RequestMethod.fromString((String)this.request.getMethod().toUpperCase());
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getHost() {
        return this.request.getServerName();
    }

    public int getPort() {
        return this.request.getServerPort();
    }

    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && forwardedForHeader.length() > 0) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    public byte[] getBody() {
        if (this.cachedBody == null || this.cachedBody.length == 0) {
            try {
                if (this.request instanceof MockHttpServletRequest) {
                    this.cachedBody = ((MockHttpServletRequest)this.request).getContentAsByteArray();
                    return this.cachedBody;
                }
                byte[] body = ByteStreams.toByteArray((InputStream)this.request.getInputStream());
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped((byte[])body);
                this.cachedBody = isGzipped ? Gzip.unGzip((byte[])body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.contentTypeHeader();
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return Charsets.UTF_8;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    public String getBodyAsString() {
        return Strings.stringFromBytes((byte[])this.getBody(), (Charset)this.encodingFromContentTypeHeaderOrUtf8());
    }

    public String getBodyAsBase64() {
        return Encoding.encodeBase64((byte[])this.getBody());
    }

    public String getHeader(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return this.request.getHeader(currentKey);
        }
        return null;
    }

    public HttpHeader header(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            ArrayList valueList = Collections.list(this.request.getHeaders(currentKey));
            if (valueList.isEmpty()) {
                return HttpHeader.empty((String)key);
            }
            return new HttpHeader(key, valueList);
        }
        return HttpHeader.absent((String)key);
    }

    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    public HttpHeaders getHeaders() {
        ArrayList headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders((Iterable)headerList);
    }

    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add((String)headerNames.nextElement());
        }
        return headerKeys;
    }

    public Map<String, Cookie> getCookies() {
        javax.servlet.http.Cookie[] cookies;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (javax.servlet.http.Cookie cookie : cookies = (javax.servlet.http.Cookie[])MoreObjects.firstNonNull((Object)this.request.getCookies(), (Object)new javax.servlet.http.Cookie[0])) {
            builder.put((Object)cookie.getName(), (Object)cookie.getValue());
        }
        return Maps.transformValues((Map)builder.build().asMap(), input -> new Cookie(null, (List)ImmutableList.copyOf((Collection)input)));
    }

    public QueryParameter queryParameter(String key) {
        return (QueryParameter)MoreObjects.firstNonNull(Urls.splitQuery((String)this.request.getQueryString()).get(key), (Object)QueryParameter.absent((String)key));
    }

    public boolean isBrowserProxyRequest() {
        if (!this.isJetty()) {
            return false;
        }
        return false;
    }

    public Collection<Request.Part> getParts() {
        if (!this.isMultipart()) {
            return null;
        }
        if (this.cachedMultiparts == null) {
            try {
                String contentTypeHeaderValue = FluentIterable.from((Iterable)this.contentTypeHeader().values()).join(Joiner.on((String)" "));
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.getBody());
                MultiPartInputStreamParser inputStreamParser = new MultiPartInputStreamParser((InputStream)inputStream, contentTypeHeaderValue, null, null);
                this.cachedMultiparts = FluentIterable.from(this.safelyGetRequestParts()).transform(WireMockHttpServletMultipartAdapter::from).toList();
            }
            catch (IOException | ServletException exception) {
                return (Collection)Exceptions.throwUnchecked((Throwable)exception, Collection.class);
            }
        }
        return this.cachedMultiparts.size() > 0 ? this.cachedMultiparts : null;
    }

    private Collection<Part> safelyGetRequestParts() throws IOException, ServletException {
        try {
            return this.request.getParts();
        }
        catch (IOException ioe) {
            if (ioe.getMessage().contains("Missing content for multipart")) {
                return Collections.emptyList();
            }
            throw ioe;
        }
    }

    public boolean isMultipart() {
        String header = this.getHeader("Content-Type");
        return header != null && header.contains("multipart");
    }

    public Request.Part getPart(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.cachedMultiparts == null && this.getParts() == null) {
            return null;
        }
        return (Request.Part)FluentIterable.from(this.cachedMultiparts).firstMatch(input -> name.equals(input.getName())).get();
    }

    public Optional<Request> getOriginalRequest() {
        Request originalRequest = (Request)this.request.getAttribute(ORIGINAL_REQUEST_KEY);
        return Optional.fromNullable((Object)originalRequest);
    }

    private boolean isJetty() {
        try {
            this.getClass("org.eclipse.jetty.server.Request");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void getClass(String type) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? com.github.tomakehurst.wiremock.servlet.WireMockHttpServletRequestAdapter.class.getClassLoader() : contextCL;
        Class.forName(type, false, loader);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }
}

