/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.scope.refresh;

import org.springframework.beans.BeansException;
import org.springframework.cloud.context.scope.GenericScope;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class RefreshScope
extends GenericScope
implements ApplicationContextAware {
    private ApplicationContext context;

    public RefreshScope() {
        super.setName("refresh");
    }

    @ManagedOperation(description="Dispose of the current instance of bean name provided and force a refresh on next method execution.")
    public void refresh(String name) {
        if (!name.startsWith("scopedTarget.")) {
            name = "scopedTarget." + name;
        }
        super.destroy(name);
        this.context.publishEvent((ApplicationEvent)new RefreshScopeRefreshedEvent(name));
    }

    @ManagedOperation(description="Dispose of the current instance of all beans in this scope and force a refresh on next method execution.")
    public void refreshAll() {
        super.destroy();
        this.context.publishEvent((ApplicationEvent)new RefreshScopeRefreshedEvent());
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

