/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.restart;

import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

public class RestartListener
implements SmartApplicationListener {
    private ConfigurableApplicationContext context;
    private ApplicationPreparedEvent event;

    public int getOrder() {
        return 0;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType) || ContextRefreshedEvent.class.isAssignableFrom(eventType) || ContextClosedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent input) {
        if (input instanceof ApplicationPreparedEvent) {
            this.event = (ApplicationPreparedEvent)input;
            if (this.context == null) {
                this.context = this.event.getApplicationContext();
            }
        } else if (input instanceof ContextRefreshedEvent) {
            if (this.context != null && input.getSource().equals(this.context) && this.event != null) {
                this.context.publishEvent((ApplicationEvent)this.event);
            }
        } else if (this.context != null && input.getSource().equals(this.context)) {
            this.context = null;
        }
    }
}

