/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.consul.retry")
public class RetryProperties {
    private long initialInterval = 1000L;
    private double multiplier = 1.1;
    private long maxInterval = 2000L;
    private int maxAttempts = 6;

    public long getInitialInterval() {
        return this.initialInterval;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setInitialInterval(long initialInterval) {
        this.initialInterval = initialInterval;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setMaxInterval(long maxInterval) {
        this.maxInterval = maxInterval;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryProperties)) {
            return false;
        }
        RetryProperties other = (RetryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialInterval() != other.getInitialInterval()) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
            return false;
        }
        if (this.getMaxInterval() != other.getMaxInterval()) {
            return false;
        }
        return this.getMaxAttempts() == other.getMaxAttempts();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RetryProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initialInterval = this.getInitialInterval();
        result = result * 59 + (int)($initialInterval >>> 32 ^ $initialInterval);
        long $multiplier = Double.doubleToLongBits(this.getMultiplier());
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        long $maxInterval = this.getMaxInterval();
        result = result * 59 + (int)($maxInterval >>> 32 ^ $maxInterval);
        result = result * 59 + this.getMaxAttempts();
        return result;
    }

    public String toString() {
        return "RetryProperties(initialInterval=" + this.getInitialInterval() + ", multiplier=" + this.getMultiplier() + ", maxInterval=" + this.getMaxInterval() + ", maxAttempts=" + this.getMaxAttempts() + ")";
    }
}

