/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Self;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ConsulHealthIndicator
extends AbstractHealthIndicator {
    private ConsulClient consul;

    public ConsulHealthIndicator(ConsulClient consul) {
        this.consul = consul;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            Response self = this.consul.getAgentSelf();
            Self.Config config = ((Self)self.getValue()).getConfig();
            Response services = this.consul.getCatalogServices(QueryParams.DEFAULT);
            builder.up().withDetail("services", services.getValue()).withDetail("advertiseAddress", (Object)config.getAdvertiseAddress()).withDetail("datacenter", (Object)config.getDatacenter()).withDetail("domain", (Object)config.getDomain()).withDetail("nodeName", (Object)config.getNodeName()).withDetail("bindAddress", (Object)config.getBindAddress()).withDetail("clientAddress", (Object)config.getClientAddress());
        }
        catch (Exception e) {
            builder.down(e);
        }
    }
}

