/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Service;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.catalog.model.Node;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.consul", ignoreUnknownFields=false)
public class ConsulEndpoint
extends AbstractEndpoint<ConsulData> {
    private ConsulClient consul;

    public ConsulEndpoint(ConsulClient consul) {
        super("consul", false, true);
        this.consul = consul;
    }

    public ConsulData invoke() {
        ConsulData data = new ConsulData();
        Response agentServices = this.consul.getAgentServices();
        data.setAgentServices((Map)agentServices.getValue());
        Response catalogServices = this.consul.getCatalogServices(QueryParams.DEFAULT);
        for (String serviceId : ((Map)catalogServices.getValue()).keySet()) {
            Response response = this.consul.getCatalogService(serviceId, QueryParams.DEFAULT);
            data.getCatalogServices().put(serviceId, (List<CatalogService>)response.getValue());
        }
        Response catalogNodes = this.consul.getCatalogNodes(QueryParams.DEFAULT);
        data.setCatalogNodes((List)catalogNodes.getValue());
        return data;
    }

    public static class ConsulData {
        Map<String, List<CatalogService>> catalogServices = new LinkedHashMap<String, List<CatalogService>>();
        Map<String, Service> agentServices;
        List<Node> catalogNodes;

        public Map<String, List<CatalogService>> getCatalogServices() {
            return this.catalogServices;
        }

        public Map<String, Service> getAgentServices() {
            return this.agentServices;
        }

        public List<Node> getCatalogNodes() {
            return this.catalogNodes;
        }

        public void setCatalogServices(Map<String, List<CatalogService>> catalogServices) {
            this.catalogServices = catalogServices;
        }

        public void setAgentServices(Map<String, Service> agentServices) {
            this.agentServices = agentServices;
        }

        public void setCatalogNodes(List<Node> catalogNodes) {
            this.catalogNodes = catalogNodes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsulData)) {
                return false;
            }
            ConsulData other = (ConsulData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, List<CatalogService>> this$catalogServices = this.getCatalogServices();
            Map<String, List<CatalogService>> other$catalogServices = other.getCatalogServices();
            if (this$catalogServices == null ? other$catalogServices != null : !((Object)this$catalogServices).equals(other$catalogServices)) {
                return false;
            }
            Map<String, Service> this$agentServices = this.getAgentServices();
            Map<String, Service> other$agentServices = other.getAgentServices();
            if (this$agentServices == null ? other$agentServices != null : !((Object)this$agentServices).equals(other$agentServices)) {
                return false;
            }
            List<Node> this$catalogNodes = this.getCatalogNodes();
            List<Node> other$catalogNodes = other.getCatalogNodes();
            return !(this$catalogNodes == null ? other$catalogNodes != null : !((Object)this$catalogNodes).equals(other$catalogNodes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConsulData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, List<CatalogService>> $catalogServices = this.getCatalogServices();
            result = result * 59 + ($catalogServices == null ? 43 : ((Object)$catalogServices).hashCode());
            Map<String, Service> $agentServices = this.getAgentServices();
            result = result * 59 + ($agentServices == null ? 43 : ((Object)$agentServices).hashCode());
            List<Node> $catalogNodes = this.getCatalogNodes();
            result = result * 59 + ($catalogNodes == null ? 43 : ((Object)$catalogNodes).hashCode());
            return result;
        }

        public String toString() {
            return "ConsulEndpoint.ConsulData(catalogServices=" + this.getCatalogServices() + ", agentServices=" + this.getAgentServices() + ", catalogNodes=" + this.getCatalogNodes() + ")";
        }
    }
}

