/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulEndpoint;
import org.springframework.cloud.consul.ConsulHealthIndicator;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.RetryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;

@Configuration
@EnableConfigurationProperties
@ConditionalOnConsulEnabled
public class ConsulAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulProperties consulProperties() {
        return new ConsulProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulClient consulClient(ConsulProperties consulProperties) {
        return new ConsulClient(consulProperties.getHost(), consulProperties.getPort());
    }

    @ConditionalOnClass(value={Retryable.class, Aspect.class, AopAutoConfiguration.class})
    @Configuration
    @EnableRetry(proxyTargetClass=true)
    @Import(value={AopAutoConfiguration.class})
    @EnableConfigurationProperties(value={RetryProperties.class})
    protected static class RetryConfiguration {
        protected RetryConfiguration() {
        }

        @Bean(name={"consulRetryInterceptor"})
        @ConditionalOnMissingBean(name={"consulRetryInterceptor"})
        public RetryOperationsInterceptor consulRetryInterceptor(RetryProperties properties) {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().backOffOptions(properties.getInitialInterval(), properties.getMultiplier(), properties.getMaxInterval()).maxAttempts(properties.getMaxAttempts()).build();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class ConsulHealthConfig {
        protected ConsulHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint(value="consul")
        public ConsulEndpoint consulEndpoint(ConsulClient consulClient) {
            return new ConsulEndpoint(consulClient);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledHealthIndicator(value="consul")
        public ConsulHealthIndicator consulHealthIndicator(ConsulClient consulClient) {
            return new ConsulHealthIndicator(consulClient);
        }
    }
}

