/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.ServiceRequestWrapper;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class RetryLoadBalancerInterceptor
implements ClientHttpRequestInterceptor {
    private LoadBalancedRetryPolicyFactory lbRetryPolicyFactory;
    private RetryTemplate retryTemplate;
    private LoadBalancerClient loadBalancer;
    private LoadBalancerRetryProperties lbProperties;

    public RetryLoadBalancerInterceptor(LoadBalancerClient loadBalancer, RetryTemplate retryTemplate, LoadBalancerRetryProperties lbProperties, LoadBalancedRetryPolicyFactory lbRetryPolicyFactory) {
        this.loadBalancer = loadBalancer;
        this.lbRetryPolicyFactory = lbRetryPolicyFactory;
        this.retryTemplate = retryTemplate;
        this.lbProperties = lbProperties;
    }

    public ClientHttpResponse intercept(final HttpRequest request, final byte[] body, final ClientHttpRequestExecution execution) throws IOException {
        URI originalUri = request.getURI();
        final String serviceName = originalUri.getHost();
        LoadBalancedRetryPolicy retryPolicy = this.lbRetryPolicyFactory.create(serviceName, this.loadBalancer);
        this.retryTemplate.setRetryPolicy((RetryPolicy)(!this.lbProperties.isEnabled() || retryPolicy == null ? new NeverRetryPolicy() : new InterceptorRetryPolicy(request, retryPolicy, this.loadBalancer, serviceName)));
        return (ClientHttpResponse)this.retryTemplate.execute((RetryCallback)new RetryCallback<ClientHttpResponse, IOException>(){

            public ClientHttpResponse doWithRetry(RetryContext context) throws IOException {
                ServiceInstance serviceInstance = null;
                if (context instanceof LoadBalancedRetryContext) {
                    LoadBalancedRetryContext lbContext = (LoadBalancedRetryContext)context;
                    serviceInstance = lbContext.getServiceInstance();
                }
                if (serviceInstance == null) {
                    serviceInstance = RetryLoadBalancerInterceptor.this.loadBalancer.choose(serviceName);
                }
                return RetryLoadBalancerInterceptor.this.loadBalancer.execute(serviceName, serviceInstance, new LoadBalancerRequest<ClientHttpResponse>(){

                    @Override
                    public ClientHttpResponse apply(ServiceInstance instance) throws Exception {
                        ServiceRequestWrapper serviceRequest = new ServiceRequestWrapper(request, instance, RetryLoadBalancerInterceptor.this.loadBalancer);
                        return execution.execute((HttpRequest)serviceRequest, body);
                    }
                });
            }
        });
    }
}

