/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.lang.reflect.Method;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationConfig;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationFeature;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.ClassUtil;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.EnumResolver;

public class EnumDeserializer
extends StdScalarDeserializer<Enum<?>> {
    private static final long serialVersionUID = -5893263645879532318L;
    protected final EnumResolver<?> _resolver;

    public EnumDeserializer(EnumResolver<?> enumResolver) {
        super(Enum.class);
        this._resolver = enumResolver;
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        Class<Object> clazz2 = annotatedMethod.getRawParameterType(0);
        if (clazz2 == String.class) {
            clazz2 = null;
        } else if (clazz2 == Integer.TYPE || clazz2 == Integer.class) {
            clazz2 = Integer.class;
        } else if (clazz2 == Long.TYPE || clazz2 == Long.class) {
            clazz2 = Long.class;
        } else {
            throw new IllegalArgumentException("Parameter #0 type for factory method (" + annotatedMethod + ") not suitable, must be java.lang.String or int/Integer/long/Long");
        }
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember());
        }
        return new FactoryBasedDeserializer(clazz, annotatedMethod, clazz2);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Enum<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getText();
            Object obj = this._resolver.findEnum(string);
            if (obj == null) {
                if (deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (string.length() == 0 || string.trim().length() == 0)) {
                    return null;
                }
                if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    throw deserializationContext.weirdStringException(string, this._resolver.getEnumClass(), "value not one of declared Enum instance names: " + this._resolver.getEnums());
                }
            }
            return obj;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                throw deserializationContext.mappingException("Not allowed to deserialize Enum value out of JSON number (disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow)");
            }
            int n = jsonParser.getIntValue();
            Object obj = this._resolver.getEnum(n);
            if (obj == null && !deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                throw deserializationContext.weirdNumberException(n, this._resolver.getEnumClass(), "index value outside legal index range [0.." + this._resolver.lastValidIndex() + "]");
            }
            return obj;
        }
        throw deserializationContext.mappingException(this._resolver.getEnumClass());
    }

    protected static class FactoryBasedDeserializer
    extends StdScalarDeserializer<Object> {
        private static final long serialVersionUID = -7775129435872564122L;
        protected final Class<?> _enumClass;
        protected final Class<?> _inputType;
        protected final Method _factory;

        public FactoryBasedDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, Class<?> clazz2) {
            super(Enum.class);
            this._enumClass = clazz;
            this._factory = annotatedMethod.getAnnotated();
            this._inputType = clazz2;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Object object;
            if (this._inputType == null) {
                object = jsonParser.getText();
            } else if (this._inputType == Integer.class) {
                object = jsonParser.getValueAsInt();
            } else if (this._inputType == Long.class) {
                object = jsonParser.getValueAsLong();
            } else {
                throw deserializationContext.mappingException(this._enumClass);
            }
            try {
                return this._factory.invoke(this._enumClass, object);
            }
            catch (Exception exception) {
                Throwable throwable = ClassUtil.getRootCause(exception);
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw deserializationContext.instantiationException(this._enumClass, throwable);
            }
        }
    }
}

