/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.context.sentinel;

import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.alicloud.context.listener.AbstractOnceApplicationListener;

public class SentinelAliCloudListener
extends AbstractOnceApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SentinelAliCloudListener.class);

    @Override
    protected void handleEvent(ApplicationEnvironmentPreparedEvent event) {
        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();
        logger.info("Sentinel Nacos datasource will" + (edasChangeOrderConfiguration.isEdasManaged() ? " be " : " not be ") + "changed by edas change order.");
        if (!edasChangeOrderConfiguration.isEdasManaged()) {
            return;
        }
        System.getProperties().setProperty("spring.cloud.sentinel.nacos.config.endpoint", edasChangeOrderConfiguration.getAddressServerDomain());
        System.getProperties().setProperty("spring.cloud.sentinel.nacos.config.namespace", edasChangeOrderConfiguration.getTenantId());
        System.getProperties().setProperty("spring.cloud.sentinel.nacos.config.access-key", edasChangeOrderConfiguration.getDauthAccessKey());
        System.getProperties().setProperty("spring.cloud.sentinel.nacos.config.secret-key", edasChangeOrderConfiguration.getDauthSecretKey());
        System.getProperties().setProperty("spring.cloud.sentinel.nacos.config.project-name", edasChangeOrderConfiguration.getProjectName());
    }

    @Override
    protected String conditionalOnClass() {
        return "com.alibaba.csp.sentinel.datasource.nacos.NacosDataSource";
    }
}

