/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.naming.NamingService;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.nacos.discovery")
public class NacosDiscoveryProperties {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryProperties.class);
    private String serverAddr;
    private String endpoint;
    private String namespace;
    private long watchDelay = 30000L;
    private String logName;
    @Value(value="${spring.cloud.nacos.discovery.service:${spring.application.name:}}")
    private String service;
    private float weight = 1.0f;
    private String clusterName = "DEFAULT";
    private String namingLoadCacheAtStart = "false";
    private Map<String, String> metadata = new HashMap<String, String>();
    private boolean registerEnabled = true;
    private String ip;
    private String networkInterface = "";
    private int port = -1;
    private boolean secure = false;
    private String accessKey;
    private String secretKey;
    @Autowired
    private InetUtils inetUtils;
    @Autowired
    private Environment environment;
    private NamingService namingService;

    @PostConstruct
    public void init() throws SocketException {
        this.metadata.put("preserved.register.source", "SPRING_CLOUD");
        if (this.secure) {
            this.metadata.put("secure", "true");
        }
        this.serverAddr = Objects.toString(this.serverAddr, "");
        if (this.serverAddr.lastIndexOf("/") != -1) {
            this.serverAddr = this.serverAddr.substring(0, this.serverAddr.length() - 1);
        }
        this.endpoint = Objects.toString(this.endpoint, "");
        this.namespace = Objects.toString(this.namespace, "");
        this.logName = Objects.toString(this.logName, "");
        if (StringUtils.isEmpty((Object)this.ip)) {
            if (StringUtils.isEmpty((Object)this.networkInterface)) {
                this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
            } else {
                NetworkInterface netInterface = NetworkInterface.getByName(this.networkInterface);
                if (null == netInterface) {
                    throw new IllegalArgumentException("no such interface " + this.networkInterface);
                }
                Enumeration<InetAddress> inetAddress = netInterface.getInetAddresses();
                while (inetAddress.hasMoreElements()) {
                    InetAddress currentAddress = inetAddress.nextElement();
                    if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress()) continue;
                    this.ip = currentAddress.getHostAddress();
                    break;
                }
                if (StringUtils.isEmpty((Object)this.ip)) {
                    throw new RuntimeException("cannot find available ip from network interface " + this.networkInterface);
                }
            }
        }
        this.overrideFromEnv(this.environment);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public void setInetUtils(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getNamingLoadCacheAtStart() {
        return this.namingLoadCacheAtStart;
    }

    public void setNamingLoadCacheAtStart(String namingLoadCacheAtStart) {
        this.namingLoadCacheAtStart = namingLoadCacheAtStart;
    }

    public long getWatchDelay() {
        return this.watchDelay;
    }

    public void setWatchDelay(long watchDelay) {
        this.watchDelay = watchDelay;
    }

    public String toString() {
        return "NacosDiscoveryProperties{serverAddr='" + this.serverAddr + '\'' + ", endpoint='" + this.endpoint + '\'' + ", namespace='" + this.namespace + '\'' + ", watchDelay=" + this.watchDelay + ", logName='" + this.logName + '\'' + ", service='" + this.service + '\'' + ", weight=" + this.weight + ", clusterName='" + this.clusterName + '\'' + ", namingLoadCacheAtStart='" + this.namingLoadCacheAtStart + '\'' + ", metadata=" + this.metadata + ", registerEnabled=" + this.registerEnabled + ", ip='" + this.ip + '\'' + ", networkInterface='" + this.networkInterface + '\'' + ", port=" + this.port + ", secure=" + this.secure + ", accessKey='" + this.accessKey + '\'' + ", secretKey='" + this.secretKey + '\'' + '}';
    }

    public void overrideFromEnv(Environment env) {
        if (StringUtils.isEmpty((Object)this.getServerAddr())) {
            this.setServerAddr(env.resolvePlaceholders("${spring.cloud.nacos.discovery.server-addr:}"));
        }
        if (StringUtils.isEmpty((Object)this.getNamespace())) {
            this.setNamespace(env.resolvePlaceholders("${spring.cloud.nacos.discovery.namespace:}"));
        }
        if (StringUtils.isEmpty((Object)this.getAccessKey())) {
            this.setAccessKey(env.resolvePlaceholders("${spring.cloud.nacos.discovery.access-key:}"));
        }
        if (StringUtils.isEmpty((Object)this.getSecretKey())) {
            this.setSecretKey(env.resolvePlaceholders("${spring.cloud.nacos.discovery.secret-key:}"));
        }
        if (StringUtils.isEmpty((Object)this.getLogName())) {
            this.setLogName(env.resolvePlaceholders("${spring.cloud.nacos.discovery.log-name:}"));
        }
        if (StringUtils.isEmpty((Object)this.getClusterName())) {
            this.setClusterName(env.resolvePlaceholders("${spring.cloud.nacos.discovery.cluster-name:}"));
        }
        if (StringUtils.isEmpty((Object)this.getEndpoint())) {
            this.setEndpoint(env.resolvePlaceholders("${spring.cloud.nacos.discovery.endpoint:}"));
        }
    }

    public NamingService namingServiceInstance() {
        if (null != this.namingService) {
            return this.namingService;
        }
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("namespace", this.namespace);
        properties.put("com.alibaba.nacos.naming.log.filename", this.logName);
        if (this.endpoint.contains(":")) {
            int index = this.endpoint.indexOf(":");
            properties.put("endpoint", this.endpoint.substring(0, index));
            properties.put("endpointPort", this.endpoint.substring(index + 1));
        } else {
            properties.put("endpoint", this.endpoint);
        }
        properties.put("accessKey", this.accessKey);
        properties.put("secretKey", this.secretKey);
        properties.put("clusterName", this.clusterName);
        properties.put("namingLoadCacheAtStart", this.namingLoadCacheAtStart);
        try {
            this.namingService = NacosFactory.createNamingService((Properties)properties);
        }
        catch (Exception e) {
            log.error("create naming service error!properties={},e=,", (Object)this, (Object)e);
            return null;
        }
        return this.namingService;
    }
}

