/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.registry;

import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Cluster;
import com.alibaba.nacos.api.naming.pojo.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.nacos.registry.NacosRegistration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.StringUtils;

public class NacosServiceRegistry
implements ServiceRegistry<NacosRegistration> {
    private static Logger logger = LoggerFactory.getLogger(NacosServiceRegistry.class);

    public void register(NacosRegistration registration) {
        if (!registration.isRegisterEnabled()) {
            logger.info("Nacos Registration is disabled...");
            return;
        }
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            logger.info("No service to register for nacos client...");
            return;
        }
        NamingService namingService = registration.getNacosNamingService();
        String serviceId = registration.getServiceId();
        Instance instance = new Instance();
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)registration.getRegisterWeight());
        instance.setCluster(new Cluster(registration.getCluster()));
        instance.setMetadata(registration.getMetadata());
        try {
            namingService.registerInstance(serviceId, instance);
            logger.info("nacos registry, {} {}:{} register finished", new Object[]{serviceId, instance.getIp(), instance.getPort()});
        }
        catch (Exception e) {
            logger.error("nacos registry, {} register failed...{},", new Object[]{serviceId, registration.toString(), e});
        }
    }

    public void deregister(NacosRegistration registration) {
        logger.info("De-registering from Nacos Server now...");
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            logger.info("No dom to de-register for nacos client...");
            return;
        }
        NamingService namingService = registration.getNacosNamingService();
        String serviceId = registration.getServiceId();
        try {
            namingService.deregisterInstance(serviceId, registration.getHost(), registration.getPort(), registration.getCluster());
        }
        catch (Exception e) {
            logger.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)registration.toString(), (Object)e);
        }
        logger.info("De-registration finished.");
    }

    public void close() {
    }

    public void setStatus(NacosRegistration registration, String status) {
    }

    public <T> T getStatus(NacosRegistration registration) {
        return null;
    }
}

