/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.NodeType;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.pool.PubSubConnectionPool;
import org.redisson.connection.pool.SlaveConnectionPool;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ConnectionManager connectionManager;
    protected final PubSubConnectionPool pubSubConnectionPool;
    protected final SlaveConnectionPool slaveConnectionPool;
    private final Map<RedisClient, ClientConnectionsEntry> client2Entry = new ConcurrentHashMap<RedisClient, ClientConnectionsEntry>();

    public LoadBalancerManager(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry entry) {
        this.connectionManager = connectionManager;
        this.slaveConnectionPool = new SlaveConnectionPool(config, connectionManager, entry);
        this.pubSubConnectionPool = new PubSubConnectionPool(config, connectionManager, entry);
    }

    public void changeType(InetSocketAddress address, NodeType nodeType) {
        ClientConnectionsEntry entry = this.getEntry(address);
        if (entry != null) {
            if (this.connectionManager.isClusterMode()) {
                entry.getClient().getConfig().setReadOnly(nodeType == NodeType.SLAVE && this.connectionManager.getServiceManager().getConfig().getReadMode() != ReadMode.MASTER);
            }
            entry.setNodeType(nodeType);
        }
    }

    public CompletableFuture<Void> add(ClientConnectionsEntry entry) {
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        if (!entry.isFreezed()) {
            CompletableFuture slaveFuture = this.slaveConnectionPool.initConnections(entry);
            CompletableFuture pubSubFuture = this.pubSubConnectionPool.initConnections(entry);
            future = CompletableFuture.allOf(slaveFuture, pubSubFuture);
        }
        return future.thenAccept(r -> {
            this.slaveConnectionPool.addEntry(entry);
            this.pubSubConnectionPool.addEntry(entry);
            this.client2Entry.put(entry.getClient(), entry);
        });
    }

    public Collection<ClientConnectionsEntry> getEntries() {
        return Collections.unmodifiableCollection(this.client2Entry.values());
    }

    public int getAvailableSlaves() {
        return (int)this.client2Entry.values().stream().filter(e -> !e.isFreezed() && e.getNodeType() == NodeType.SLAVE).count();
    }

    public int getAvailableClients() {
        int count = 0;
        for (ClientConnectionsEntry connectionEntry : this.client2Entry.values()) {
            if (connectionEntry.isFreezed()) continue;
            ++count;
        }
        return count;
    }

    public CompletableFuture<Boolean> unfreezeAsync(RedisURI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.getEntry(address);
        if (entry == null) {
            this.log.error("Can't find {} in slaves! Available slaves: {}", (Object)address, this.client2Entry.keySet());
            return CompletableFuture.completedFuture(false);
        }
        return this.unfreezeAsync(entry, freezeReason);
    }

    public CompletableFuture<Boolean> unfreezeAsync(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry entry = this.getEntry(address);
        if (entry == null) {
            this.log.error("Can't find {} in slaves! Available slaves: {}", (Object)address, this.client2Entry.keySet());
            return CompletableFuture.completedFuture(false);
        }
        return this.unfreezeAsync(entry, freezeReason);
    }

    public CompletableFuture<Boolean> unfreezeAsync(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason) {
        return this.unfreezeAsync(entry, freezeReason, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> unfreezeAsync(ClientConnectionsEntry entry, ClientConnectionsEntry.FreezeReason freezeReason, int retry) {
        ClientConnectionsEntry clientConnectionsEntry = entry;
        synchronized (clientConnectionsEntry) {
            if (!entry.isFreezed()) {
                return CompletableFuture.completedFuture(false);
            }
            if (!(freezeReason == ClientConnectionsEntry.FreezeReason.RECONNECT && entry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.RECONNECT || entry.isInitialized())) {
                entry.setInitialized(true);
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(2);
                futures.add(this.slaveConnectionPool.initConnections(entry));
                futures.add(this.pubSubConnectionPool.initConnections(entry));
                CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                CompletableFuture<Boolean> f = new CompletableFuture<Boolean>();
                future.whenComplete((r, e) -> {
                    if (e != null) {
                        int maxAttempts = this.connectionManager.getServiceManager().getConfig().getRetryAttempts();
                        int retryInterval = this.connectionManager.getServiceManager().getConfig().getRetryInterval();
                        this.log.error("Unable to unfreeze entry: {} attempt: {} of {}", new Object[]{entry, retry, maxAttempts, e});
                        entry.setInitialized(false);
                        if (retry < maxAttempts) {
                            this.connectionManager.getServiceManager().newTimeout(t -> {
                                CompletableFuture<Boolean> ff = this.unfreezeAsync(entry, freezeReason, retry + 1);
                                this.connectionManager.getServiceManager().transfer(ff, f);
                            }, retryInterval, TimeUnit.MILLISECONDS);
                        } else {
                            f.complete(false);
                        }
                        return;
                    }
                    entry.resetFirstFail();
                    entry.setFreezeReason(null);
                    this.log.debug("Unfreezed entry: {} after {} attempts", (Object)entry, (Object)retry);
                    f.complete(true);
                });
                return f;
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    public ClientConnectionsEntry freeze(RedisURI address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry connectionEntry = this.getEntry(address);
        return this.freeze(connectionEntry, freezeReason);
    }

    public ClientConnectionsEntry freeze(InetSocketAddress address, ClientConnectionsEntry.FreezeReason freezeReason) {
        ClientConnectionsEntry connectionEntry = this.getEntry(address);
        return this.freeze(connectionEntry, freezeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConnectionsEntry freeze(ClientConnectionsEntry connectionEntry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (connectionEntry == null || connectionEntry.isFailed() && connectionEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT && freezeReason == ClientConnectionsEntry.FreezeReason.RECONNECT) {
            return null;
        }
        ClientConnectionsEntry clientConnectionsEntry = connectionEntry;
        synchronized (clientConnectionsEntry) {
            if (connectionEntry.isFreezed()) {
                return null;
            }
            if (connectionEntry.getFreezeReason() == null || connectionEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT || freezeReason == ClientConnectionsEntry.FreezeReason.MANAGER && connectionEntry.getFreezeReason() != ClientConnectionsEntry.FreezeReason.MANAGER && connectionEntry.getNodeType() == NodeType.SLAVE) {
                connectionEntry.setFreezeReason(freezeReason);
                return connectionEntry;
            }
        }
        return connectionEntry;
    }

    public CompletableFuture<RedisPubSubConnection> nextPubSubConnection() {
        return this.pubSubConnectionPool.get();
    }

    public CompletableFuture<RedisPubSubConnection> nextPubSubConnection(ClientConnectionsEntry entry) {
        return this.pubSubConnectionPool.get(entry);
    }

    public boolean contains(InetSocketAddress addr) {
        return this.getEntry(addr) != null;
    }

    public boolean contains(RedisURI addr) {
        return this.getEntry(addr) != null;
    }

    public boolean contains(RedisClient redisClient) {
        return this.getEntry(redisClient) != null;
    }

    public ClientConnectionsEntry getEntry(RedisURI addr) {
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            InetSocketAddress entryAddr = entry.getClient().getAddr();
            if (!addr.equals(entryAddr)) continue;
            return entry;
        }
        return null;
    }

    private ClientConnectionsEntry getEntry(InetSocketAddress address) {
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            InetSocketAddress addr = entry.getClient().getAddr();
            if (!addr.getAddress().equals(address.getAddress()) || addr.getPort() != address.getPort()) continue;
            return entry;
        }
        return null;
    }

    public ClientConnectionsEntry getEntry(RedisClient redisClient) {
        return this.client2Entry.get(redisClient);
    }

    public CompletableFuture<RedisConnection> getConnection(RedisCommand<?> command, RedisURI addr) {
        ClientConnectionsEntry entry = this.getEntry(addr);
        if (entry != null) {
            return this.slaveConnectionPool.get((RedisCommand)command, entry);
        }
        RedisConnectionException exception = new RedisConnectionException("Can't find entry for " + addr);
        CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
        f.completeExceptionally(exception);
        return f;
    }

    public CompletableFuture<RedisConnection> getConnection(RedisCommand<?> command, RedisClient client) {
        ClientConnectionsEntry entry = this.getEntry(client);
        if (entry != null) {
            return this.slaveConnectionPool.get((RedisCommand)command, entry);
        }
        RedisConnectionException exception = new RedisConnectionException("Can't find entry for " + client);
        CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
        f.completeExceptionally(exception);
        return f;
    }

    public CompletableFuture<RedisConnection> nextConnection(RedisCommand<?> command) {
        return this.slaveConnectionPool.get((RedisCommand)command);
    }

    public void returnPubSubConnection(RedisPubSubConnection connection) {
        ClientConnectionsEntry entry = this.getEntry(connection.getRedisClient());
        this.pubSubConnectionPool.returnConnection(entry, connection);
    }

    public void returnConnection(RedisConnection connection) {
        ClientConnectionsEntry entry = this.getEntry(connection.getRedisClient());
        this.slaveConnectionPool.returnConnection(entry, connection);
    }

    public CompletableFuture<Void> shutdownAsync() {
        if (this.client2Entry.values().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (ClientConnectionsEntry entry : this.client2Entry.values()) {
            futures.add(entry.shutdownAsync());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }
}

