/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.DNSMonitor;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.ServiceManager;
import org.redisson.connection.SingleEntry;
import org.redisson.misc.RedisURI;
import org.redisson.pubsub.PublishSubscribeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveConnectionManager
implements ConnectionManager {
    public static final int MAX_SLOT = 16384;
    protected final ClusterSlotRange singleSlotRange = new ClusterSlotRange(0, 16383);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected DNSMonitor dnsMonitor;
    protected MasterSlaveServersConfig config;
    private MasterSlaveEntry masterSlaveEntry;
    protected final PublishSubscribeService subscribeService;
    protected final ServiceManager serviceManager;
    private final Map<RedisURI, RedisConnection> nodeConnections = new ConcurrentHashMap<RedisURI, RedisConnection>();
    protected volatile boolean isConnected;
    protected final AtomicReference<CompletableFuture<Void>> lazyConnectLatch = new AtomicReference();
    private boolean lastAttempt;

    public MasterSlaveConnectionManager(BaseMasterSlaveServersConfig<?> cfg, ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        if (cfg instanceof MasterSlaveServersConfig) {
            this.config = (MasterSlaveServersConfig)cfg;
            if (this.config.getSlaveAddresses().isEmpty() && (this.config.getReadMode() == ReadMode.SLAVE || this.config.getReadMode() == ReadMode.MASTER_SLAVE)) {
                throw new IllegalArgumentException("Slaves aren't defined. readMode can't be SLAVE or MASTER_SLAVE");
            }
        } else {
            this.config = this.create(cfg);
        }
        serviceManager.setConfig(this.config);
        serviceManager.initTimer();
        this.subscribeService = new PublishSubscribeService(this);
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    protected void closeNodeConnections() {
        this.nodeConnections.values().stream().map(c -> c.getRedisClient().shutdownAsync()).forEach(f -> f.toCompletableFuture().join());
    }

    protected void closeNodeConnection(RedisConnection conn) {
        if (this.nodeConnections.values().removeAll(Arrays.asList(conn))) {
            conn.closeAsync();
        }
    }

    protected final void disconnectNode(RedisURI addr) {
        RedisConnection conn = this.nodeConnections.remove(addr);
        if (conn != null) {
            this.nodeConnections.values().removeAll(Arrays.asList(conn));
            conn.closeAsync();
        }
    }

    protected final CompletionStage<RedisConnection> connectToNode(BaseConfig<?> cfg, RedisURI addr, String sslHostname) {
        return this.connectToNode(NodeType.MASTER, cfg, addr, sslHostname);
    }

    protected final CompletionStage<RedisConnection> connectToNode(NodeType type, BaseConfig<?> cfg, RedisURI addr, String sslHostname) {
        RedisConnection conn = this.nodeConnections.get(addr);
        if (conn != null) {
            if (!conn.isActive()) {
                this.closeNodeConnection(conn);
            } else {
                return CompletableFuture.completedFuture(conn);
            }
        }
        RedisClient client = this.createClient(type, addr, cfg.getConnectTimeout(), cfg.getTimeout(), sslHostname);
        RFuture<RedisConnection> future = client.connectAsync();
        return future.thenCompose(connection -> {
            if (connection.isActive()) {
                if (!addr.isIP()) {
                    RedisURI address = new RedisURI(addr.getScheme() + "://" + connection.getRedisClient().getAddr().getAddress().getHostAddress() + ":" + connection.getRedisClient().getAddr().getPort());
                    this.nodeConnections.put(address, (RedisConnection)connection);
                }
                this.nodeConnections.put(addr, (RedisConnection)connection);
                return CompletableFuture.completedFuture(connection);
            }
            connection.closeAsync();
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(new RedisException("Connection to " + connection.getRedisClient().getAddr() + " is not active!"));
            return f;
        });
    }

    @Override
    public boolean isClusterMode() {
        return false;
    }

    @Override
    public Collection<MasterSlaveEntry> getEntrySet() {
        this.lazyConnect();
        if (this.masterSlaveEntry != null) {
            return Collections.singletonList(this.masterSlaveEntry);
        }
        return Collections.emptyList();
    }

    protected final void lazyConnect() {
        if (!this.serviceManager.getCfg().isLazyInitialization() || this.isConnected) {
            return;
        }
        CompletableFuture f = new CompletableFuture();
        if (!this.lazyConnectLatch.compareAndSet(null, f)) {
            this.lazyConnectLatch.get().join();
            return;
        }
        try {
            this.connect();
            f.complete(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            f.completeExceptionally(e);
            this.lazyConnectLatch.set(null);
            throw e;
        }
    }

    @Override
    public final void connect() throws InterruptedException {
        int attempts = this.config.getRetryAttempts() + 1;
        for (int i = 0; i < attempts; ++i) {
            try {
                if (i == attempts - 1) {
                    this.lastAttempt = true;
                }
                this.doConnect();
                return;
            }
            catch (Exception e) {
                if (i == attempts - 1) {
                    this.lastAttempt = false;
                    throw e;
                }
                try {
                    Thread.sleep(this.config.getRetryInterval());
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    protected void doConnect() {
        try {
            this.masterSlaveEntry = this.config.isSlaveNotUsed() ? new SingleEntry(this, this.serviceManager.getConnectionWatcher(), this.config) : new MasterSlaveEntry(this, this.serviceManager.getConnectionWatcher(), this.config);
            CompletableFuture<RedisClient> masterFuture = this.masterSlaveEntry.setupMasterEntry(new RedisURI(this.config.getMasterAddress()));
            masterFuture.join();
            if (!this.config.isSlaveNotUsed()) {
                CompletableFuture<Void> fs = this.masterSlaveEntry.initSlaveBalancer(this.getDisconnectedNodes());
                fs.join();
            }
            this.startDNSMonitoring(masterFuture.getNow(null));
        }
        catch (Exception e) {
            this.internalShutdown();
            if (e instanceof CompletionException) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RedisConnectionException(e.getCause());
            }
            throw e;
        }
    }

    protected void startDNSMonitoring(RedisClient masterHost) {
        if (masterHost.getConfig().getAddress().isIP()) {
            return;
        }
        if (this.config.getDnsMonitoringInterval() != -1L) {
            Set<RedisURI> slaveAddresses = this.config.getSlaveAddresses().stream().map(r -> new RedisURI((String)r)).collect(Collectors.toSet());
            this.dnsMonitor = new DNSMonitor(this, masterHost, slaveAddresses, this.config.getDnsMonitoringInterval(), this.serviceManager.getResolverGroup());
            this.dnsMonitor.start();
        }
    }

    protected Collection<RedisURI> getDisconnectedNodes() {
        return Collections.emptySet();
    }

    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig c = new MasterSlaveServersConfig();
        c.setPingConnectionInterval(cfg.getPingConnectionInterval());
        c.setSslEnableEndpointIdentification(cfg.isSslEnableEndpointIdentification());
        c.setSslProvider(cfg.getSslProvider());
        c.setSslTruststore(cfg.getSslTruststore());
        c.setSslTruststorePassword(cfg.getSslTruststorePassword());
        c.setSslKeystore(cfg.getSslKeystore());
        c.setSslKeystorePassword(cfg.getSslKeystorePassword());
        c.setSslProtocols(cfg.getSslProtocols());
        c.setSslCiphers(cfg.getSslCiphers());
        c.setSslKeyManagerFactory(cfg.getSslKeyManagerFactory());
        c.setSslTrustManagerFactory(cfg.getSslTrustManagerFactory());
        c.setRetryInterval(cfg.getRetryInterval());
        c.setRetryAttempts(cfg.getRetryAttempts());
        c.setTimeout(cfg.getTimeout());
        c.setLoadBalancer(cfg.getLoadBalancer());
        c.setPassword(cfg.getPassword());
        c.setUsername(cfg.getUsername());
        c.setClientName(cfg.getClientName());
        c.setMasterConnectionPoolSize(cfg.getMasterConnectionPoolSize());
        c.setSlaveConnectionPoolSize(cfg.getSlaveConnectionPoolSize());
        c.setSubscriptionConnectionPoolSize(cfg.getSubscriptionConnectionPoolSize());
        c.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        c.setConnectTimeout(cfg.getConnectTimeout());
        c.setIdleConnectionTimeout(cfg.getIdleConnectionTimeout());
        c.setFailedSlaveCheckInterval(cfg.getFailedSlaveCheckInterval());
        c.setFailedSlaveReconnectionInterval(cfg.getFailedSlaveReconnectionInterval());
        c.setMasterConnectionMinimumIdleSize(cfg.getMasterConnectionMinimumIdleSize());
        c.setSlaveConnectionMinimumIdleSize(cfg.getSlaveConnectionMinimumIdleSize());
        c.setSubscriptionConnectionMinimumIdleSize(cfg.getSubscriptionConnectionMinimumIdleSize());
        c.setReadMode(cfg.getReadMode());
        c.setSubscriptionMode(cfg.getSubscriptionMode());
        c.setDnsMonitoringInterval(cfg.getDnsMonitoringInterval());
        c.setKeepAlive(cfg.isKeepAlive());
        c.setTcpNoDelay(cfg.isTcpNoDelay());
        c.setNameMapper(cfg.getNameMapper());
        c.setCredentialsResolver(cfg.getCredentialsResolver());
        c.setCommandMapper(cfg.getCommandMapper());
        return c;
    }

    @Override
    public RedisClient createClient(NodeType type, RedisURI address, String sslHostname) {
        RedisClient client = this.createClient(type, address, this.config.getConnectTimeout(), this.config.getTimeout(), sslHostname);
        return client;
    }

    @Override
    public RedisClient createClient(NodeType type, InetSocketAddress address, RedisURI uri, String sslHostname) {
        RedisClient client = this.createClient(type, address, uri, this.config.getConnectTimeout(), this.config.getTimeout(), sslHostname);
        return client;
    }

    protected RedisClient createClient(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = this.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        return RedisClient.create(redisConfig);
    }

    private RedisClient createClient(NodeType type, InetSocketAddress address, RedisURI uri, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = this.createRedisConfig(type, null, timeout, commandTimeout, sslHostname);
        redisConfig.setAddress(address, uri);
        return RedisClient.create(redisConfig);
    }

    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = new RedisClientConfig();
        redisConfig.setAddress(address).setTimer((Timer)this.serviceManager.getTimer()).setExecutor(this.serviceManager.getExecutor()).setResolverGroup(this.serviceManager.getResolverGroup()).setGroup(this.serviceManager.getGroup()).setSocketChannelClass(this.serviceManager.getSocketChannelClass()).setConnectTimeout(timeout).setCommandTimeout(commandTimeout).setSslHostname(sslHostname).setSslEnableEndpointIdentification(this.config.isSslEnableEndpointIdentification()).setSslProvider(this.config.getSslProvider()).setSslTruststore(this.config.getSslTruststore()).setSslTruststorePassword(this.config.getSslTruststorePassword()).setSslKeystore(this.config.getSslKeystore()).setSslKeystorePassword(this.config.getSslKeystorePassword()).setSslProtocols(this.config.getSslProtocols()).setSslCiphers(this.config.getSslCiphers()).setSslKeyManagerFactory(this.config.getSslKeyManagerFactory()).setSslTrustManagerFactory(this.config.getSslTrustManagerFactory()).setClientName(this.config.getClientName()).setKeepPubSubOrder(this.serviceManager.getCfg().isKeepPubSubOrder()).setPingConnectionInterval(this.config.getPingConnectionInterval()).setKeepAlive(this.config.isKeepAlive()).setTcpNoDelay(this.config.isTcpNoDelay()).setUsername(this.config.getUsername()).setPassword(this.config.getPassword()).setNettyHook(this.serviceManager.getCfg().getNettyHook()).setCommandMapper(this.config.getCommandMapper()).setCredentialsResolver(this.config.getCredentialsResolver()).setConnectedListener(addr -> {
            this.isConnected = true;
            if (!this.serviceManager.isShuttingDown()) {
                NodeType nt = this.getNodeType(type, (InetSocketAddress)addr);
                this.serviceManager.getConnectionEventsHub().fireConnect((InetSocketAddress)addr, nt);
            }
        }).setDisconnectedListener(addr -> {
            if (!this.serviceManager.isShuttingDown()) {
                NodeType nt = this.getNodeType(type, (InetSocketAddress)addr);
                this.serviceManager.getConnectionEventsHub().fireDisconnect((InetSocketAddress)addr, nt);
            }
        });
        if (type != NodeType.SENTINEL) {
            redisConfig.setDatabase(this.config.getDatabase());
        }
        return redisConfig;
    }

    private NodeType getNodeType(NodeType type, InetSocketAddress address) {
        if (type != NodeType.SENTINEL) {
            MasterSlaveEntry entry = this.getEntry(address);
            if (entry != null) {
                if (!entry.isInit()) {
                    return type;
                }
                InetSocketAddress addr = entry.getClient().getAddr();
                if (addr.getAddress().equals(address.getAddress()) && addr.getPort() == address.getPort()) {
                    return NodeType.MASTER;
                }
            }
            return NodeType.SLAVE;
        }
        return type;
    }

    @Override
    public int calcSlot(String key) {
        return this.singleSlotRange.getStartSlot();
    }

    @Override
    public int calcSlot(byte[] key) {
        return this.singleSlotRange.getStartSlot();
    }

    @Override
    public MasterSlaveEntry getEntry(InetSocketAddress address) {
        this.lazyConnect();
        return this.masterSlaveEntry;
    }

    @Override
    public MasterSlaveEntry getEntry(RedisURI addr) {
        this.lazyConnect();
        return this.masterSlaveEntry;
    }

    @Override
    public MasterSlaveEntry getEntry(RedisClient redisClient) {
        this.lazyConnect();
        return this.masterSlaveEntry;
    }

    @Override
    public MasterSlaveEntry getEntry(String name) {
        int slot = this.calcSlot(name);
        return this.getEntry(slot);
    }

    protected MasterSlaveEntry getEntry(int slot) {
        this.lazyConnect();
        return this.masterSlaveEntry;
    }

    @Override
    public MasterSlaveEntry getWriteEntry(int slot) {
        return this.getEntry(slot);
    }

    @Override
    public MasterSlaveEntry getReadEntry(int slot) {
        return this.getEntry(slot);
    }

    protected CompletableFuture<RedisClient> changeMaster(int slot, RedisURI address) {
        MasterSlaveEntry entry = this.getEntry(slot);
        return entry.changeMaster(address);
    }

    protected void internalShutdown() {
        if (this.lazyConnectLatch.get() == null && this.lastAttempt) {
            this.shutdown();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        if (this.dnsMonitor != null) {
            this.dnsMonitor.stop();
        }
        this.serviceManager.getConnectionWatcher().stop();
        if (this.isConnected) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (MasterSlaveEntry entry : this.getEntrySet()) {
                futures.add(entry.shutdownAsync());
            }
            CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            try {
                future.get(timeout, unit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serviceManager.getResolverGroup().close();
        this.serviceManager.getShutdownLatch().close();
        if (this.serviceManager.getCfg().getExecutor() == null) {
            this.serviceManager.getExecutor().shutdown();
            try {
                this.serviceManager.getExecutor().awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.serviceManager.getShutdownPromise().trySuccess(null);
        this.serviceManager.getShutdownLatch().awaitUninterruptibly();
        if (this.serviceManager.getCfg().getEventLoopGroup() == null) {
            this.serviceManager.getGroup().shutdownGracefully(quietPeriod, timeout, unit).syncUninterruptibly();
        }
        this.serviceManager.getTimer().stop();
    }

    @Override
    public PublishSubscribeService getSubscribeService() {
        return this.subscribeService;
    }

    @Override
    public RedisURI getLastClusterNode() {
        return null;
    }
}

