/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncSemaphore {
    private final AtomicInteger counter;
    private final Queue<Runnable> listeners = new ConcurrentLinkedQueue<Runnable>();
    private final Set<Runnable> removedListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public AsyncSemaphore(int permits) {
        this.counter = new AtomicInteger(permits);
    }

    public boolean tryAcquire(long timeoutMillis) {
        CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = () -> latch.countDown();
        this.acquire(runnable);
        try {
            boolean r = latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            if (!r) {
                this.remove(runnable);
            }
            return r;
        }
        catch (InterruptedException e) {
            this.remove(runnable);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public int queueSize() {
        return this.listeners.size() - this.removedListeners.size();
    }

    public void removeListeners() {
        this.listeners.clear();
        this.removedListeners.clear();
    }

    public void acquire(Runnable listener) {
        this.listeners.add(listener);
        this.tryRun();
    }

    private void tryRun() {
        if (this.counter.get() == 0 || this.listeners.peek() == null) {
            return;
        }
        if (this.counter.decrementAndGet() >= 0) {
            Runnable listener = this.listeners.poll();
            if (listener == null) {
                this.counter.incrementAndGet();
                return;
            }
            if (this.removedListeners.remove(listener)) {
                this.counter.incrementAndGet();
                this.tryRun();
            } else {
                listener.run();
            }
        } else {
            this.counter.incrementAndGet();
        }
    }

    public void remove(Runnable listener) {
        this.removedListeners.add(listener);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void release() {
        this.counter.incrementAndGet();
        this.tryRun();
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }
}

