/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PingConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PingConnectionHandler.class);
    private final RedisClientConfig config;

    public PingConnectionHandler(RedisClientConfig config) {
        this.config = config;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        ((RedisConnection)connection).getConnectionPromise().onComplete((res, e) -> {
            if (e == null) {
                this.sendPing(ctx);
            }
        });
        ctx.fireChannelActive();
    }

    private void sendPing(ChannelHandlerContext ctx) {
        Object connection = RedisConnection.getFrom(ctx.channel());
        CommandData<?, ?> commandData = ((RedisConnection)connection).getCurrentCommand();
        RFuture future = (commandData == null || !commandData.isBlockingCommand()) && !((RedisConnection)connection).isQueued() ? ((RedisConnection)connection).async(StringCodec.INSTANCE, RedisCommands.PING, new Object[0]) : null;
        this.config.getTimer().newTimeout(new TimerTask((RedisConnection)connection, ctx, future){
            final /* synthetic */ RedisConnection val$connection;
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ RFuture val$future;
            {
                this.val$connection = redisConnection;
                this.val$ctx = channelHandlerContext;
                this.val$future = rFuture;
            }

            public void run(Timeout timeout) throws Exception {
                if (this.val$connection.isClosed() || this.val$ctx.isRemoved()) {
                    return;
                }
                CommandData<?, ?> commandData = this.val$connection.getCurrentCommand();
                if (commandData != null && commandData.isBlockingCommand()) {
                    PingConnectionHandler.this.sendPing(this.val$ctx);
                    return;
                }
                if (this.val$future != null && (this.val$future.cancel(false) || !this.val$future.isSuccess())) {
                    this.val$ctx.channel().close();
                    if (this.val$future.cause() != null && !this.val$future.isCancelled()) {
                        log.error("Unable to send PING command over channel: " + this.val$ctx.channel(), this.val$future.cause());
                    }
                    log.debug("channel: {} closed due to PING response timeout set in {} ms", (Object)this.val$ctx.channel(), (Object)PingConnectionHandler.this.config.getPingConnectionInterval());
                } else {
                    PingConnectionHandler.this.sendPing(this.val$ctx);
                }
            }
        }, (long)this.config.getPingConnectionInterval(), TimeUnit.MILLISECONDS);
    }
}

